/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.jdbc.adapter;

import com.google.common.base.Preconditions;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.shardingsphere.core.constant.DatabaseType;
import org.apache.shardingsphere.shardingjdbc.jdbc.unsupported.AbstractUnsupportedOperationDataSource;
import org.apache.shardingsphere.transaction.ShardingTransactionManagerEngine;

public abstract class AbstractDataSourceAdapter
extends AbstractUnsupportedOperationDataSource
implements AutoCloseable {
    private final DatabaseType databaseType;
    private final Map<String, DataSource> dataSourceMap;
    private ShardingTransactionManagerEngine shardingTransactionManagerEngine = new ShardingTransactionManagerEngine();
    private PrintWriter logWriter = new PrintWriter(System.out);

    public AbstractDataSourceAdapter(Map<String, DataSource> dataSourceMap) throws SQLException {
        this.databaseType = this.getDatabaseType(dataSourceMap.values());
        this.shardingTransactionManagerEngine.init(this.databaseType, dataSourceMap);
        this.dataSourceMap = dataSourceMap;
    }

    protected final DatabaseType getDatabaseType(Collection<DataSource> dataSources) throws SQLException {
        DatabaseType result = null;
        for (DataSource each : dataSources) {
            DatabaseType databaseType = this.getDatabaseType(each);
            Preconditions.checkState((null == result || result.equals((Object)databaseType) ? 1 : 0) != 0, (Object)String.format("Database type inconsistent with '%s' and '%s'", result, databaseType));
            result = databaseType;
        }
        return result;
    }

    private DatabaseType getDatabaseType(DataSource dataSource) throws SQLException {
        if (dataSource instanceof AbstractDataSourceAdapter) {
            return ((AbstractDataSourceAdapter)dataSource).databaseType;
        }
        try (Connection connection = dataSource.getConnection();){
            DatabaseType databaseType = DatabaseType.valueFrom((String)connection.getMetaData().getDatabaseProductName());
            return databaseType;
        }
    }

    @Override
    public final Logger getParentLogger() {
        return Logger.getLogger("global");
    }

    @Override
    public final Connection getConnection(String username, String password) throws SQLException {
        return this.getConnection();
    }

    @Override
    public void close() throws Exception {
        for (DataSource each : this.dataSourceMap.values()) {
            try {
                Method method = each.getClass().getDeclaredMethod("close", new Class[0]);
                method.setAccessible(true);
                method.invoke((Object)each, new Object[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {}
        }
        this.shardingTransactionManagerEngine.close();
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public Map<String, DataSource> getDataSourceMap() {
        return this.dataSourceMap;
    }

    public ShardingTransactionManagerEngine getShardingTransactionManagerEngine() {
        return this.shardingTransactionManagerEngine;
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public void setShardingTransactionManagerEngine(ShardingTransactionManagerEngine shardingTransactionManagerEngine) {
        this.shardingTransactionManagerEngine = shardingTransactionManagerEngine;
    }

    @Override
    public void setLogWriter(PrintWriter logWriter) {
        this.logWriter = logWriter;
    }
}

