/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.jdbc.core.connection;

import java.beans.ConstructorProperties;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.apache.shardingsphere.core.constant.DatabaseType;
import org.apache.shardingsphere.core.parse.EncryptSQLParsingEngine;
import org.apache.shardingsphere.core.rule.EncryptRule;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.statement.EncryptPreparedStatement;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.statement.EncryptStatement;
import org.apache.shardingsphere.shardingjdbc.jdbc.unsupported.AbstractUnsupportedOperationConnection;

public final class EncryptConnection
extends AbstractUnsupportedOperationConnection {
    private final Connection connection;
    private final EncryptRule encryptRule;
    private final DatabaseType databaseType;
    private final EncryptSQLParsingEngine encryptSQLParsingEngine;

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.connection.getMetaData();
    }

    @Override
    public Statement createStatement() {
        return new EncryptStatement(this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) {
        return new EncryptStatement(this, resultSetType, resultSetConcurrency);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return new EncryptStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) {
        return new EncryptPreparedStatement(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) {
        return new EncryptPreparedStatement(this, sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return new EncryptPreparedStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) {
        return new EncryptPreparedStatement(this, sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) {
        return new EncryptPreparedStatement(this, sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) {
        return new EncryptPreparedStatement(this, sql, columnNames);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.connection.getAutoCommit();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.connection.setAutoCommit(autoCommit);
    }

    @Override
    public void commit() throws SQLException {
        this.connection.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.connection.rollback();
    }

    @Override
    public void close() throws SQLException {
        this.connection.close();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.connection.isClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.connection.setReadOnly(readOnly);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.connection.getTransactionIsolation();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.connection.setTransactionIsolation(level);
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public void clearWarnings() {
    }

    @Override
    public int getHoldability() {
        return 2;
    }

    @Override
    public void setHoldability(int holdability) {
    }

    public Connection getConnection() {
        return this.connection;
    }

    public EncryptRule getEncryptRule() {
        return this.encryptRule;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public EncryptSQLParsingEngine getEncryptSQLParsingEngine() {
        return this.encryptSQLParsingEngine;
    }

    @ConstructorProperties(value={"connection", "encryptRule", "databaseType", "encryptSQLParsingEngine"})
    public EncryptConnection(Connection connection, EncryptRule encryptRule, DatabaseType databaseType, EncryptSQLParsingEngine encryptSQLParsingEngine) {
        this.connection = connection;
        this.encryptRule = encryptRule;
        this.databaseType = databaseType;
        this.encryptSQLParsingEngine = encryptSQLParsingEngine;
    }
}

