/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.jdbc.core.datasource;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.shardingsphere.api.config.masterslave.MasterSlaveRuleConfiguration;
import org.apache.shardingsphere.core.constant.properties.ShardingProperties;
import org.apache.shardingsphere.core.rule.MasterSlaveRule;
import org.apache.shardingsphere.shardingjdbc.jdbc.adapter.AbstractDataSourceAdapter;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.connection.MasterSlaveConnection;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.datasource.metadata.CachedDatabaseMetaData;
import org.apache.shardingsphere.transaction.core.TransactionTypeHolder;

public class MasterSlaveDataSource
extends AbstractDataSourceAdapter {
    private final DatabaseMetaData cachedDatabaseMetaData;
    private final MasterSlaveRule masterSlaveRule;
    private final ShardingProperties shardingProperties;

    public MasterSlaveDataSource(Map<String, DataSource> dataSourceMap, MasterSlaveRuleConfiguration masterSlaveRuleConfig, Properties props) throws SQLException {
        super(dataSourceMap);
        this.cachedDatabaseMetaData = this.createCachedDatabaseMetaData(dataSourceMap);
        this.masterSlaveRule = new MasterSlaveRule(masterSlaveRuleConfig);
        this.shardingProperties = new ShardingProperties(null == props ? new Properties() : props);
    }

    public MasterSlaveDataSource(Map<String, DataSource> dataSourceMap, MasterSlaveRule masterSlaveRule, Properties props) throws SQLException {
        super(dataSourceMap);
        this.cachedDatabaseMetaData = this.createCachedDatabaseMetaData(dataSourceMap);
        this.masterSlaveRule = masterSlaveRule;
        this.shardingProperties = new ShardingProperties(null == props ? new Properties() : props);
    }

    private DatabaseMetaData createCachedDatabaseMetaData(Map<String, DataSource> dataSourceMap) throws SQLException {
        try (Connection connection = dataSourceMap.values().iterator().next().getConnection();){
            CachedDatabaseMetaData cachedDatabaseMetaData = new CachedDatabaseMetaData(connection.getMetaData(), dataSourceMap, null);
            return cachedDatabaseMetaData;
        }
    }

    @Override
    public final MasterSlaveConnection getConnection() {
        return new MasterSlaveConnection(this, this.getDataSourceMap(), this.getShardingTransactionManagerEngine(), TransactionTypeHolder.get());
    }

    public DatabaseMetaData getCachedDatabaseMetaData() {
        return this.cachedDatabaseMetaData;
    }

    public MasterSlaveRule getMasterSlaveRule() {
        return this.masterSlaveRule;
    }

    public ShardingProperties getShardingProperties() {
        return this.shardingProperties;
    }
}

