/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.jdbc.core.datasource.metadata;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.shardingjdbc.jdbc.adapter.WrapperAdapter;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.resultset.DatabaseMetaDataResultSet;

public abstract class ResultSetReturnedDatabaseMetaData
extends WrapperAdapter
implements DatabaseMetaData {
    private final Map<String, DataSource> dataSourceMap;
    private final ShardingRule shardingRule;
    private Connection currentConnection;
    private String currentDataSourceName;

    public ResultSetReturnedDatabaseMetaData(Map<String, DataSource> dataSourceMap, ShardingRule shardingRule) {
        this.dataSourceMap = dataSourceMap;
        this.shardingRule = shardingRule;
    }

    @Override
    public final Connection getConnection() throws SQLException {
        return this.getCurrentConnection();
    }

    @Override
    public final ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        try (Connection connection = this.getConnection();){
            DatabaseMetaDataResultSet databaseMetaDataResultSet = new DatabaseMetaDataResultSet(connection.getMetaData().getSuperTypes(catalog, schemaPattern, typeNamePattern), this.shardingRule);
            return databaseMetaDataResultSet;
        }
    }

    @Override
    public final ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        String actualTableNamePattern = this.getActualTableNamePattern(tableNamePattern);
        try (Connection connection = this.getConnection();){
            DatabaseMetaDataResultSet databaseMetaDataResultSet = new DatabaseMetaDataResultSet(connection.getMetaData().getSuperTables(catalog, schemaPattern, actualTableNamePattern), this.shardingRule);
            return databaseMetaDataResultSet;
        }
    }

    @Override
    public final ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        try (Connection connection = this.getConnection();){
            DatabaseMetaDataResultSet databaseMetaDataResultSet = new DatabaseMetaDataResultSet(connection.getMetaData().getAttributes(catalog, schemaPattern, typeNamePattern, attributeNamePattern), this.shardingRule);
            return databaseMetaDataResultSet;
        }
    }

    @Override
    public final ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        try (Connection connection = this.getConnection();){
            DatabaseMetaDataResultSet databaseMetaDataResultSet = new DatabaseMetaDataResultSet(connection.getMetaData().getProcedures(catalog, schemaPattern, procedureNamePattern), this.shardingRule);
            return databaseMetaDataResultSet;
        }
    }

    @Override
    public final ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        try (Connection connection = this.getConnection();){
            DatabaseMetaDataResultSet databaseMetaDataResultSet = new DatabaseMetaDataResultSet(connection.getMetaData().getProcedureColumns(catalog, schemaPattern, procedureNamePattern, columnNamePattern), this.shardingRule);
            return databaseMetaDataResultSet;
        }
    }

    @Override
    public final ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        String actualTableNamePattern = this.getActualTableNamePattern(tableNamePattern);
        try (Connection connection = this.getConnection();){
            DatabaseMetaDataResultSet databaseMetaDataResultSet = new DatabaseMetaDataResultSet(connection.getMetaData().getTables(catalog, schemaPattern, actualTableNamePattern, types), this.shardingRule);
            return databaseMetaDataResultSet;
        }
    }

    @Override
    public final ResultSet getSchemas() throws SQLException {
        try (Connection connection = this.getConnection();){
            DatabaseMetaDataResultSet databaseMetaDataResultSet = new DatabaseMetaDataResultSet(connection.getMetaData().getSchemas(), this.shardingRule);
            return databaseMetaDataResultSet;
        }
    }

    @Override
    public final ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        try (Connection connection = this.getConnection();){
            DatabaseMetaDataResultSet databaseMetaDataResultSet = new DatabaseMetaDataResultSet(connection.getMetaData().getSchemas(catalog, schemaPattern), this.shardingRule);
            return databaseMetaDataResultSet;
        }
    }

    @Override
    public final ResultSet getCatalogs() throws SQLException {
        try (Connection connection = this.getConnection();){
            DatabaseMetaDataResultSet databaseMetaDataResultSet = new DatabaseMetaDataResultSet(connection.getMetaData().getCatalogs(), this.shardingRule);
            return databaseMetaDataResultSet;
        }
    }

    @Override
    public final ResultSet getTableTypes() throws SQLException {
        try (Connection connection = this.getConnection();){
            DatabaseMetaDataResultSet databaseMetaDataResultSet = new DatabaseMetaDataResultSet(connection.getMetaData().getTableTypes(), this.shardingRule);
            return databaseMetaDataResultSet;
        }
    }

    @Override
    public final ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String actualTableNamePattern = this.getActualTableNamePattern(tableNamePattern);
        try (Connection connection = this.getConnection();){
            DatabaseMetaDataResultSet databaseMetaDataResultSet = new DatabaseMetaDataResultSet(connection.getMetaData().getColumns(catalog, schemaPattern, actualTableNamePattern, columnNamePattern), this.shardingRule);
            return databaseMetaDataResultSet;
        }
    }

    @Override
    public final ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        String actualTable = this.getActualTable(table);
        try (Connection connection = this.getConnection();){
            DatabaseMetaDataResultSet databaseMetaDataResultSet = new DatabaseMetaDataResultSet(connection.getMetaData().getColumnPrivileges(catalog, schema, actualTable, columnNamePattern), this.shardingRule);
            return databaseMetaDataResultSet;
        }
    }

    @Override
    public final ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        String actualTableNamePattern = this.getActualTableNamePattern(tableNamePattern);
        try (Connection connection = this.getConnection();){
            DatabaseMetaDataResultSet databaseMetaDataResultSet = new DatabaseMetaDataResultSet(connection.getMetaData().getTablePrivileges(catalog, schemaPattern, actualTableNamePattern), this.shardingRule);
            return databaseMetaDataResultSet;
        }
    }

    @Override
    public final ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        String actualTable = this.getActualTable(table);
        try (Connection connection = this.getConnection();){
            DatabaseMetaDataResultSet databaseMetaDataResultSet = new DatabaseMetaDataResultSet(connection.getMetaData().getBestRowIdentifier(catalog, schema, actualTable, scope, nullable), this.shardingRule);
            return databaseMetaDataResultSet;
        }
    }

    @Override
    public final ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        String actualTable = this.getActualTable(table);
        try (Connection connection = this.getConnection();){
            DatabaseMetaDataResultSet databaseMetaDataResultSet = new DatabaseMetaDataResultSet(connection.getMetaData().getVersionColumns(catalog, schema, actualTable), this.shardingRule);
            return databaseMetaDataResultSet;
        }
    }

    @Override
    public final ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        String actualTable = this.getActualTable(table);
        try (Connection connection = this.getConnection();){
            DatabaseMetaDataResultSet databaseMetaDataResultSet = new DatabaseMetaDataResultSet(connection.getMetaData().getPrimaryKeys(catalog, schema, actualTable), this.shardingRule);
            return databaseMetaDataResultSet;
        }
    }

    @Override
    public final ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        String actualTable = this.getActualTable(table);
        try (Connection connection = this.getConnection();){
            DatabaseMetaDataResultSet databaseMetaDataResultSet = new DatabaseMetaDataResultSet(connection.getMetaData().getImportedKeys(catalog, schema, actualTable), this.shardingRule);
            return databaseMetaDataResultSet;
        }
    }

    @Override
    public final ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        String actualTable = this.getActualTable(table);
        try (Connection connection = this.getConnection();){
            DatabaseMetaDataResultSet databaseMetaDataResultSet = new DatabaseMetaDataResultSet(connection.getMetaData().getExportedKeys(catalog, schema, actualTable), this.shardingRule);
            return databaseMetaDataResultSet;
        }
    }

    @Override
    public final ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        try (Connection connection = this.getConnection();){
            DatabaseMetaDataResultSet databaseMetaDataResultSet = new DatabaseMetaDataResultSet(connection.getMetaData().getCrossReference(parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable), this.shardingRule);
            return databaseMetaDataResultSet;
        }
    }

    @Override
    public final ResultSet getTypeInfo() throws SQLException {
        try (Connection connection = this.getConnection();){
            DatabaseMetaDataResultSet databaseMetaDataResultSet = new DatabaseMetaDataResultSet(connection.getMetaData().getTypeInfo(), this.shardingRule);
            return databaseMetaDataResultSet;
        }
    }

    @Override
    public final ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        String actualTable = this.getActualTable(table);
        try (Connection connection = this.getConnection();){
            DatabaseMetaDataResultSet databaseMetaDataResultSet = new DatabaseMetaDataResultSet(connection.getMetaData().getIndexInfo(catalog, schema, actualTable, unique, approximate), this.shardingRule);
            return databaseMetaDataResultSet;
        }
    }

    @Override
    public final ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        try (Connection connection = this.getConnection();){
            DatabaseMetaDataResultSet databaseMetaDataResultSet = new DatabaseMetaDataResultSet(connection.getMetaData().getUDTs(catalog, schemaPattern, typeNamePattern, types), this.shardingRule);
            return databaseMetaDataResultSet;
        }
    }

    @Override
    public final ResultSet getClientInfoProperties() throws SQLException {
        try (Connection connection = this.getConnection();){
            DatabaseMetaDataResultSet databaseMetaDataResultSet = new DatabaseMetaDataResultSet(connection.getMetaData().getClientInfoProperties(), this.shardingRule);
            return databaseMetaDataResultSet;
        }
    }

    @Override
    public final ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        try (Connection connection = this.getConnection();){
            DatabaseMetaDataResultSet databaseMetaDataResultSet = new DatabaseMetaDataResultSet(connection.getMetaData().getFunctions(catalog, schemaPattern, functionNamePattern), this.shardingRule);
            return databaseMetaDataResultSet;
        }
    }

    @Override
    public final ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        try (Connection connection = this.getConnection();){
            DatabaseMetaDataResultSet databaseMetaDataResultSet = new DatabaseMetaDataResultSet(connection.getMetaData().getFunctionColumns(catalog, schemaPattern, functionNamePattern, columnNamePattern), this.shardingRule);
            return databaseMetaDataResultSet;
        }
    }

    @Override
    public final ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String actualTableNamePattern = this.getActualTableNamePattern(tableNamePattern);
        try (Connection connection = this.getConnection();){
            DatabaseMetaDataResultSet databaseMetaDataResultSet = new DatabaseMetaDataResultSet(connection.getMetaData().getPseudoColumns(catalog, schemaPattern, actualTableNamePattern, columnNamePattern), this.shardingRule);
            return databaseMetaDataResultSet;
        }
    }

    private Connection getCurrentConnection() throws SQLException {
        if (null == this.currentConnection || this.currentConnection.isClosed()) {
            DataSource dataSource = null == this.shardingRule ? this.dataSourceMap.values().iterator().next() : this.dataSourceMap.get(this.getCurrentDataSourceName());
            this.currentConnection = dataSource.getConnection();
        }
        return this.currentConnection;
    }

    private String getCurrentDataSourceName() {
        this.currentDataSourceName = this.shardingRule.getShardingDataSourceNames().getRandomDataSourceName();
        return this.shardingRule.getShardingDataSourceNames().getRawMasterDataSourceName(this.currentDataSourceName);
    }

    private String getActualTableNamePattern(String tableNamePattern) {
        return null == tableNamePattern ? tableNamePattern : (this.shardingRule.findTableRule(tableNamePattern).isPresent() ? "%" + tableNamePattern + "%" : tableNamePattern);
    }

    private String getActualTable(String table) {
        return null == table || null == this.shardingRule ? table : (this.shardingRule.findTableRule(table).isPresent() ? this.shardingRule.getDataNode(this.currentDataSourceName, table).getTableName() : table);
    }
}

