/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.jdbc.core.resultset;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import org.apache.shardingsphere.core.execute.sql.execute.result.StreamQueryResult;
import org.apache.shardingsphere.core.merge.dql.iterator.IteratorStreamMergedResult;
import org.apache.shardingsphere.core.rule.EncryptRule;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.resultset.ResultSetUtil;
import org.apache.shardingsphere.shardingjdbc.jdbc.unsupported.AbstractUnsupportedOperationResultSet;

public final class EncryptResultSet
extends AbstractUnsupportedOperationResultSet {
    private final Statement encryptStatement;
    private ResultSet originalResultSet;
    private IteratorStreamMergedResult resultSet;

    public EncryptResultSet(Statement encryptStatement, ResultSet resultSet, EncryptRule encryptRule) {
        this.encryptStatement = encryptStatement;
        this.originalResultSet = resultSet;
        StreamQueryResult queryResult = new StreamQueryResult(resultSet, null, encryptRule.getEncryptorEngine());
        this.resultSet = new IteratorStreamMergedResult(Collections.singletonList(queryResult));
    }

    @Override
    public boolean next() throws SQLException {
        return this.resultSet.next();
    }

    @Override
    public boolean wasNull() {
        return this.resultSet.wasNull();
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return (Boolean)ResultSetUtil.convertValue(this.resultSet.getValue(columnIndex, Boolean.TYPE), Boolean.TYPE);
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return (Boolean)ResultSetUtil.convertValue(this.resultSet.getValue(columnLabel, Boolean.TYPE), Boolean.TYPE);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return (Byte)ResultSetUtil.convertValue(this.resultSet.getValue(columnIndex, Byte.TYPE), Byte.TYPE);
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return (Byte)ResultSetUtil.convertValue(this.resultSet.getValue(columnLabel, Byte.TYPE), Byte.TYPE);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return (Short)ResultSetUtil.convertValue(this.resultSet.getValue(columnIndex, Short.TYPE), Short.TYPE);
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return (Short)ResultSetUtil.convertValue(this.resultSet.getValue(columnLabel, Short.TYPE), Short.TYPE);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return (Integer)ResultSetUtil.convertValue(this.resultSet.getValue(columnIndex, Integer.TYPE), Integer.TYPE);
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return (Integer)ResultSetUtil.convertValue(this.resultSet.getValue(columnLabel, Integer.TYPE), Integer.TYPE);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return (Long)ResultSetUtil.convertValue(this.resultSet.getValue(columnIndex, Long.TYPE), Long.TYPE);
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return (Long)ResultSetUtil.convertValue(this.resultSet.getValue(columnLabel, Long.TYPE), Long.TYPE);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return ((Float)ResultSetUtil.convertValue(this.resultSet.getValue(columnIndex, Float.TYPE), Float.TYPE)).floatValue();
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return ((Float)ResultSetUtil.convertValue(this.resultSet.getValue(columnLabel, Float.TYPE), Float.TYPE)).floatValue();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return (Double)ResultSetUtil.convertValue(this.resultSet.getValue(columnIndex, Double.TYPE), Double.TYPE);
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return (Double)ResultSetUtil.convertValue(this.resultSet.getValue(columnLabel, Double.TYPE), Double.TYPE);
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return (String)ResultSetUtil.convertValue(this.resultSet.getValue(columnIndex, String.class), String.class);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return (String)ResultSetUtil.convertValue(this.resultSet.getValue(columnLabel, String.class), String.class);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return (BigDecimal)ResultSetUtil.convertValue(this.resultSet.getValue(columnIndex, BigDecimal.class), BigDecimal.class);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return (BigDecimal)ResultSetUtil.convertValue(this.resultSet.getValue(columnLabel, BigDecimal.class), BigDecimal.class);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return (BigDecimal)ResultSetUtil.convertValue(this.resultSet.getValue(columnIndex, BigDecimal.class), BigDecimal.class);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return (BigDecimal)ResultSetUtil.convertValue(this.resultSet.getValue(columnLabel, BigDecimal.class), BigDecimal.class);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return (byte[])ResultSetUtil.convertValue(this.resultSet.getValue(columnIndex, byte[].class), byte[].class);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return (byte[])ResultSetUtil.convertValue(this.resultSet.getValue(columnLabel, byte[].class), byte[].class);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return (Date)ResultSetUtil.convertValue(this.resultSet.getValue(columnIndex, Date.class), Date.class);
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return (Date)ResultSetUtil.convertValue(this.resultSet.getValue(columnLabel, Date.class), Date.class);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return (Date)ResultSetUtil.convertValue(this.resultSet.getCalendarValue(columnIndex, Date.class, cal), Date.class);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return (Date)ResultSetUtil.convertValue(this.resultSet.getCalendarValue(columnLabel, Date.class, cal), Date.class);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return (Time)ResultSetUtil.convertValue(this.resultSet.getValue(columnIndex, Time.class), Time.class);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return (Time)ResultSetUtil.convertValue(this.resultSet.getValue(columnLabel, Time.class), Time.class);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return (Time)ResultSetUtil.convertValue(this.resultSet.getCalendarValue(columnIndex, Time.class, cal), Time.class);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return (Time)ResultSetUtil.convertValue(this.resultSet.getCalendarValue(columnLabel, Time.class, cal), Time.class);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return (Timestamp)ResultSetUtil.convertValue(this.resultSet.getValue(columnIndex, Timestamp.class), Timestamp.class);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return (Timestamp)ResultSetUtil.convertValue(this.resultSet.getValue(columnLabel, Timestamp.class), Timestamp.class);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return (Timestamp)ResultSetUtil.convertValue(this.resultSet.getCalendarValue(columnIndex, Timestamp.class, cal), Timestamp.class);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return (Timestamp)ResultSetUtil.convertValue(this.resultSet.getCalendarValue(columnLabel, Timestamp.class, cal), Timestamp.class);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.resultSet.getInputStream(columnIndex, "Ascii");
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.resultSet.getInputStream(columnLabel, "Ascii");
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return this.resultSet.getInputStream(columnIndex, "Unicode");
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this.resultSet.getInputStream(columnLabel, "Unicode");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this.resultSet.getInputStream(columnIndex, "Binary");
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.resultSet.getInputStream(columnLabel, "Binary");
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return (Reader)this.resultSet.getValue(columnIndex, Reader.class);
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return (Reader)this.resultSet.getValue(columnLabel, Reader.class);
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        return (Blob)this.resultSet.getValue(columnIndex, Blob.class);
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return (Blob)this.resultSet.getValue(columnLabel, Blob.class);
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        return (Clob)this.resultSet.getValue(columnIndex, Clob.class);
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return (Clob)this.resultSet.getValue(columnLabel, Clob.class);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        return (URL)this.resultSet.getValue(columnIndex, URL.class);
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return (URL)this.resultSet.getValue(columnLabel, URL.class);
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        return (SQLXML)this.resultSet.getValue(columnIndex, SQLXML.class);
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return (SQLXML)this.resultSet.getValue(columnLabel, SQLXML.class);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.resultSet.getValue(columnIndex, Object.class);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.resultSet.getValue(columnLabel, Object.class);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.originalResultSet.getMetaData();
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        return this.originalResultSet.findColumn(columnLabel);
    }

    @Override
    public void close() throws SQLException {
        this.originalResultSet.close();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.originalResultSet.isClosed();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.originalResultSet.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.originalResultSet.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.originalResultSet.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.originalResultSet.getFetchSize();
    }

    @Override
    public int getType() throws SQLException {
        return this.originalResultSet.getType();
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this.originalResultSet.getConcurrency();
    }

    @Override
    public Statement getStatement() {
        return this.encryptStatement;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.originalResultSet.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.originalResultSet.clearWarnings();
    }
}

