/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.jdbc.core.resultset;

import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.Collections;
import java.util.Iterator;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.resultset.GeneratedKeysResultSetMetaData;
import org.apache.shardingsphere.shardingjdbc.jdbc.unsupported.AbstractUnsupportedGeneratedKeysResultSet;

public final class GeneratedKeysResultSet
extends AbstractUnsupportedGeneratedKeysResultSet {
    private final Iterator<Comparable<?>> generatedKeys;
    private final String generatedKeyColumn;
    private final Statement statement;
    private boolean closed;
    private Comparable<?> currentGeneratedKey;

    public GeneratedKeysResultSet() {
        this.generatedKeys = Collections.emptyList().iterator();
        this.generatedKeyColumn = null;
        this.statement = null;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean next() {
        if (this.closed || !this.generatedKeys.hasNext()) {
            this.currentGeneratedKey = null;
            return false;
        }
        this.currentGeneratedKey = this.generatedKeys.next();
        return true;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public ResultSetMetaData getMetaData() {
        this.checkState();
        return new GeneratedKeysResultSetMetaData(this.generatedKeyColumn);
    }

    @Override
    public boolean wasNull() {
        this.checkState();
        return false;
    }

    @Override
    public String getString(int columnIndex) {
        this.checkStateForGetData();
        return this.currentGeneratedKey.toString();
    }

    @Override
    public String getString(String columnLabel) {
        return this.getString(1);
    }

    @Override
    public byte getByte(int columnIndex) {
        this.checkStateForGetData();
        return Byte.valueOf(this.getString(columnIndex));
    }

    @Override
    public byte getByte(String columnLabel) {
        return this.getByte(1);
    }

    @Override
    public short getShort(int columnIndex) {
        this.checkStateForGetData();
        return Short.valueOf(this.getString(columnIndex));
    }

    @Override
    public short getShort(String columnLabel) {
        return this.getShort(1);
    }

    @Override
    public int getInt(int columnIndex) {
        this.checkStateForGetData();
        return Integer.valueOf(this.getString(columnIndex));
    }

    @Override
    public int getInt(String columnLabel) {
        return this.getInt(1);
    }

    @Override
    public long getLong(int columnIndex) {
        this.checkStateForGetData();
        return Long.valueOf(this.getString(columnIndex));
    }

    @Override
    public long getLong(String columnLabel) {
        return this.getLong(1);
    }

    @Override
    public float getFloat(int columnIndex) {
        this.checkStateForGetData();
        return Float.valueOf(this.getString(columnIndex)).floatValue();
    }

    @Override
    public float getFloat(String columnLabel) {
        return this.getFloat(1);
    }

    @Override
    public double getDouble(int columnIndex) {
        this.checkStateForGetData();
        return Double.valueOf(this.getString(columnIndex));
    }

    @Override
    public double getDouble(String columnLabel) {
        return this.getDouble(1);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) {
        this.checkStateForGetData();
        return new BigDecimal(this.getString(columnIndex)).setScale(scale, 4);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) {
        return this.getBigDecimal(1, scale);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) {
        this.checkStateForGetData();
        return new BigDecimal(this.getString(columnIndex));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) {
        return this.getBigDecimal(1);
    }

    @Override
    public byte[] getBytes(int columnIndex) {
        this.checkStateForGetData();
        return this.getString(columnIndex).getBytes();
    }

    @Override
    public byte[] getBytes(String columnLabel) {
        return this.getBytes(1);
    }

    @Override
    public Object getObject(int columnIndex) {
        this.checkStateForGetData();
        return this.currentGeneratedKey;
    }

    @Override
    public Object getObject(String columnLabel) {
        return this.getObject(1);
    }

    @Override
    public int findColumn(String columnLabel) {
        this.checkState();
        return 1;
    }

    @Override
    public int getType() {
        this.checkState();
        return 1003;
    }

    @Override
    public int getConcurrency() {
        this.checkState();
        return 1007;
    }

    @Override
    public Statement getStatement() {
        this.checkState();
        return this.statement;
    }

    private void checkState() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"ResultSet has closed.");
    }

    private void checkStateForGetData() {
        this.checkState();
        Preconditions.checkNotNull(this.currentGeneratedKey, (Object)"ResultSet should call next or has no more data.");
    }

    @ConstructorProperties(value={"generatedKeys", "generatedKeyColumn", "statement"})
    public GeneratedKeysResultSet(Iterator<Comparable<?>> generatedKeys, String generatedKeyColumn, Statement statement) {
        this.generatedKeys = generatedKeys;
        this.generatedKeyColumn = generatedKeyColumn;
        this.statement = statement;
    }
}

