/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.jdbc.core.statement;

import java.beans.ConstructorProperties;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.shardingsphere.core.optimize.OptimizeEngineFactory;
import org.apache.shardingsphere.core.optimize.result.OptimizeResult;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.rewrite.EncryptSQLRewriteEngine;
import org.apache.shardingsphere.core.rewrite.SQLBuilder;
import org.apache.shardingsphere.core.route.SQLUnit;
import org.apache.shardingsphere.core.rule.EncryptRule;
import org.apache.shardingsphere.shardingjdbc.jdbc.adapter.AbstractShardingPreparedStatementAdapter;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.connection.EncryptConnection;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.resultset.EncryptResultSet;

public final class EncryptPreparedStatement
extends AbstractShardingPreparedStatementAdapter {
    private final String sql;
    private final EncryptPreparedStatementGenerator preparedStatementGenerator;
    private final Collection<SQLUnit> sqlUnits = new LinkedList<SQLUnit>();
    private PreparedStatement preparedStatement;
    private EncryptResultSet resultSet;

    public EncryptPreparedStatement(EncryptConnection connection, String sql) {
        this.sql = sql;
        this.preparedStatementGenerator = new EncryptPreparedStatementGenerator(connection);
    }

    public EncryptPreparedStatement(EncryptConnection connection, String sql, int resultSetType, int resultSetConcurrency) {
        this.sql = sql;
        this.preparedStatementGenerator = new EncryptPreparedStatementGenerator(connection, resultSetType, resultSetConcurrency);
    }

    public EncryptPreparedStatement(EncryptConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this.sql = sql;
        this.preparedStatementGenerator = new EncryptPreparedStatementGenerator(connection, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public EncryptPreparedStatement(EncryptConnection connection, String sql, int autoGeneratedKeys) {
        this.sql = sql;
        this.preparedStatementGenerator = new EncryptPreparedStatementGenerator(connection, autoGeneratedKeys);
    }

    public EncryptPreparedStatement(EncryptConnection connection, String sql, int[] columnIndexes) {
        this.sql = sql;
        this.preparedStatementGenerator = new EncryptPreparedStatementGenerator(connection, columnIndexes);
    }

    public EncryptPreparedStatement(EncryptConnection connection, String sql, String[] columnNames) {
        this.sql = sql;
        this.preparedStatementGenerator = new EncryptPreparedStatementGenerator(connection, columnNames);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        try {
            SQLUnit sqlUnit = this.getSQLUnit(this.sql);
            this.preparedStatement = this.preparedStatementGenerator.createPreparedStatement(sqlUnit.getSql());
            this.replaySetParameter(this.preparedStatement, sqlUnit.getParameters());
            EncryptResultSet encryptResultSet = this.resultSet = new EncryptResultSet(this, this.preparedStatement.executeQuery(), this.preparedStatementGenerator.connection.getEncryptRule());
            return encryptResultSet;
        }
        finally {
            this.clearParameters();
        }
    }

    @Override
    public ResultSet getResultSet() {
        return this.resultSet;
    }

    @Override
    public int executeUpdate() throws SQLException {
        try {
            SQLUnit sqlUnit = this.getSQLUnit(this.sql);
            this.preparedStatement = this.preparedStatementGenerator.createPreparedStatement(sqlUnit.getSql());
            this.replaySetParameter(this.preparedStatement, sqlUnit.getParameters());
            int n = this.preparedStatement.executeUpdate();
            return n;
        }
        finally {
            this.clearParameters();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() throws SQLException {
        try {
            SQLUnit sqlUnit = this.getSQLUnit(this.sql);
            this.preparedStatement = this.preparedStatementGenerator.createPreparedStatement(sqlUnit.getSql());
            this.replaySetParameter(this.preparedStatement, sqlUnit.getParameters());
            boolean result = this.preparedStatement.execute();
            this.resultSet = this.createEncryptResultSet(this.preparedStatement);
            boolean bl = result;
            return bl;
        }
        finally {
            this.clearParameters();
        }
    }

    private EncryptResultSet createEncryptResultSet(PreparedStatement preparedStatement) throws SQLException {
        return null == preparedStatement.getResultSet() ? null : new EncryptResultSet(this, preparedStatement.getResultSet(), this.preparedStatementGenerator.connection.getEncryptRule());
    }

    @Override
    public void addBatch() {
        this.sqlUnits.add(this.getSQLUnit(this.sql));
        this.clearParameters();
    }

    private SQLUnit getSQLUnit(String sql) {
        EncryptConnection connection = this.preparedStatementGenerator.connection;
        SQLStatement sqlStatement = connection.getEncryptSQLParsingEngine().parse(true, sql);
        OptimizeResult optimizeResult = OptimizeEngineFactory.newInstance((EncryptRule)connection.getEncryptRule(), (SQLStatement)sqlStatement, this.getParameters()).optimize();
        SQLBuilder sqlBuilder = new EncryptSQLRewriteEngine(connection.getEncryptRule(), sql, connection.getDatabaseType(), sqlStatement, this.getParameters(), optimizeResult).rewrite();
        return sqlBuilder.toSQL();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try {
            this.preparedStatement = this.preparedStatementGenerator.createPreparedStatement(this.sqlUnits.iterator().next().getSql());
            this.replayBatchPreparedStatement();
            int[] nArray = this.preparedStatement.executeBatch();
            return nArray;
        }
        finally {
            this.clearBatch();
        }
    }

    private void replayBatchPreparedStatement() throws SQLException {
        for (SQLUnit each : this.sqlUnits) {
            this.replaySetParameter(this.preparedStatement, each.getParameters());
            this.preparedStatement.addBatch();
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.preparedStatement.clearBatch();
        this.sqlUnits.clear();
        this.clearParameters();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.preparedStatement.getGeneratedKeys();
    }

    @Override
    public Connection getConnection() {
        return this.preparedStatementGenerator.connection;
    }

    @Override
    public int getResultSetConcurrency() {
        return this.preparedStatementGenerator.resultSetConcurrency;
    }

    @Override
    public int getResultSetType() {
        return this.preparedStatementGenerator.resultSetType;
    }

    @Override
    public int getResultSetHoldability() {
        return this.preparedStatementGenerator.resultSetHoldability;
    }

    @Override
    protected boolean isAccumulate() {
        return false;
    }

    @Override
    protected Collection<? extends Statement> getRoutedStatements() {
        LinkedList<PreparedStatement> result = new LinkedList<PreparedStatement>();
        result.add(this.preparedStatement);
        return result;
    }

    private final class EncryptPreparedStatementGenerator {
        private final EncryptConnection connection;
        private final int resultSetType;
        private final int resultSetConcurrency;
        private final int resultSetHoldability;
        private final int autoGeneratedKeys;
        private final int[] columnIndexes;
        private final String[] columnNames;

        private EncryptPreparedStatementGenerator(EncryptConnection connection) {
            this(connection, -1, -1, -1, -1, null, null);
        }

        private EncryptPreparedStatementGenerator(EncryptConnection connection, int resultSetType, int resultSetConcurrency) {
            this(connection, resultSetType, resultSetConcurrency, -1, -1, null, null);
        }

        private EncryptPreparedStatementGenerator(EncryptConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
            this(connection, resultSetType, resultSetConcurrency, resultSetHoldability, -1, null, null);
        }

        private EncryptPreparedStatementGenerator(EncryptConnection connection, int autoGeneratedKeys) {
            this(connection, -1, -1, -1, autoGeneratedKeys, null, null);
        }

        private EncryptPreparedStatementGenerator(EncryptConnection connection, int[] columnIndexes) {
            this(connection, -1, -1, -1, -1, columnIndexes, null);
        }

        private EncryptPreparedStatementGenerator(EncryptConnection connection, String[] columnNames) {
            this(connection, -1, -1, -1, -1, null, columnNames);
        }

        private PreparedStatement createPreparedStatement(String sql) throws SQLException {
            if (-1 != this.resultSetType && -1 != this.resultSetConcurrency && -1 != this.resultSetHoldability) {
                return this.connection.getConnection().prepareStatement(sql, this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
            }
            if (-1 != this.resultSetType && -1 != this.resultSetConcurrency) {
                return this.connection.getConnection().prepareStatement(sql, this.resultSetType, this.resultSetConcurrency);
            }
            if (-1 != this.autoGeneratedKeys) {
                return this.connection.getConnection().prepareStatement(sql, this.autoGeneratedKeys);
            }
            if (null != this.columnIndexes) {
                return this.connection.getConnection().prepareStatement(sql, this.columnIndexes);
            }
            if (null != this.columnNames) {
                return this.connection.getConnection().prepareStatement(sql, this.columnNames);
            }
            return this.connection.getConnection().prepareStatement(sql);
        }

        @ConstructorProperties(value={"connection", "resultSetType", "resultSetConcurrency", "resultSetHoldability", "autoGeneratedKeys", "columnIndexes", "columnNames"})
        public EncryptPreparedStatementGenerator(EncryptConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability, int autoGeneratedKeys, int[] columnIndexes, String[] columnNames) {
            this.connection = connection;
            this.resultSetType = resultSetType;
            this.resultSetConcurrency = resultSetConcurrency;
            this.resultSetHoldability = resultSetHoldability;
            this.autoGeneratedKeys = autoGeneratedKeys;
            this.columnIndexes = columnIndexes;
            this.columnNames = columnNames;
        }
    }
}

