/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.jdbc.core.statement;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.LinkedList;
import org.apache.shardingsphere.core.optimize.OptimizeEngineFactory;
import org.apache.shardingsphere.core.optimize.result.OptimizeResult;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.rewrite.EncryptSQLRewriteEngine;
import org.apache.shardingsphere.core.rewrite.SQLBuilder;
import org.apache.shardingsphere.core.rule.EncryptRule;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.connection.EncryptConnection;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.resultset.EncryptResultSet;
import org.apache.shardingsphere.shardingjdbc.jdbc.unsupported.AbstractUnsupportedOperationStatement;

public final class EncryptStatement
extends AbstractUnsupportedOperationStatement {
    private final Statement statement;
    private final EncryptConnection connection;
    private EncryptResultSet resultSet;

    public EncryptStatement(EncryptConnection connection) {
        this.statement = connection.getConnection().createStatement();
        this.connection = connection;
    }

    public EncryptStatement(EncryptConnection connection, int resultSetType, int resultSetConcurrency) {
        this.statement = connection.getConnection().createStatement(resultSetType, resultSetConcurrency);
        this.connection = connection;
    }

    public EncryptStatement(EncryptConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this.statement = connection.getConnection().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        this.connection = connection;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        ResultSet resultSet = this.statement.executeQuery(this.getRewriteSQL(sql));
        this.resultSet = new EncryptResultSet(this, resultSet, this.connection.getEncryptRule());
        return this.resultSet;
    }

    @Override
    public ResultSet getResultSet() {
        return this.resultSet;
    }

    private String getRewriteSQL(String sql) {
        SQLStatement sqlStatement = this.connection.getEncryptSQLParsingEngine().parse(false, sql);
        OptimizeResult optimizeResult = OptimizeEngineFactory.newInstance((EncryptRule)this.connection.getEncryptRule(), (SQLStatement)sqlStatement, new LinkedList()).optimize();
        SQLBuilder sqlBuilder = new EncryptSQLRewriteEngine(this.connection.getEncryptRule(), sql, this.connection.getDatabaseType(), sqlStatement, new LinkedList(), optimizeResult).rewrite();
        return sqlBuilder.toSQL().getSql();
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.statement.executeUpdate(this.getRewriteSQL(sql));
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.statement.executeUpdate(this.getRewriteSQL(sql), autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.statement.executeUpdate(this.getRewriteSQL(sql), columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.statement.executeUpdate(this.getRewriteSQL(sql), columnNames);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        boolean result = this.statement.execute(this.getRewriteSQL(sql));
        this.resultSet = this.createEncryptResultSet(this.statement);
        return result;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        boolean result = this.statement.execute(this.getRewriteSQL(sql), autoGeneratedKeys);
        this.resultSet = this.createEncryptResultSet(this.statement);
        return result;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        boolean result = this.statement.execute(this.getRewriteSQL(sql), columnIndexes);
        this.resultSet = this.createEncryptResultSet(this.statement);
        return result;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        boolean result = this.statement.execute(this.getRewriteSQL(sql), columnNames);
        this.resultSet = this.createEncryptResultSet(this.statement);
        return result;
    }

    private EncryptResultSet createEncryptResultSet(Statement statement) throws SQLException {
        return null == statement.getResultSet() ? null : new EncryptResultSet(this, statement.getResultSet(), this.connection.getEncryptRule());
    }

    @Override
    public void close() throws SQLException {
        this.statement.close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.statement.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.statement.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.statement.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.statement.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.statement.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.statement.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.statement.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.statement.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.statement.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.statement.clearWarnings();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.statement.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.statement.getMoreResults();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.statement.getMoreResults(current);
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.statement.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.statement.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.statement.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.statement.getResultSetType();
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.statement.getGeneratedKeys();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.statement.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.statement.isClosed();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.statement.setPoolable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.statement.isPoolable();
    }
}

