/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.jdbc.core.statement;

import com.google.common.base.Preconditions;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.shardingsphere.core.constant.properties.ShardingPropertiesConstant;
import org.apache.shardingsphere.core.route.router.masterslave.MasterSlaveRouter;
import org.apache.shardingsphere.shardingjdbc.jdbc.adapter.AbstractMasterSlavePreparedStatementAdapter;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.connection.MasterSlaveConnection;

public final class MasterSlavePreparedStatement
extends AbstractMasterSlavePreparedStatementAdapter {
    private final MasterSlaveConnection connection;
    private final MasterSlaveRouter masterSlaveRouter;
    private final Collection<PreparedStatement> routedStatements = new LinkedList<PreparedStatement>();

    public MasterSlavePreparedStatement(MasterSlaveConnection connection, String sql) throws SQLException {
        this(connection, sql, 1003, 1007, 1);
    }

    public MasterSlavePreparedStatement(MasterSlaveConnection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this(connection, sql, resultSetType, resultSetConcurrency, 1);
    }

    public MasterSlavePreparedStatement(MasterSlaveConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.connection = connection;
        this.masterSlaveRouter = new MasterSlaveRouter(connection.getMasterSlaveDataSource().getMasterSlaveRule(), ((Boolean)connection.getMasterSlaveDataSource().getShardingProperties().getValue(ShardingPropertiesConstant.SQL_SHOW)).booleanValue());
        for (String each : this.masterSlaveRouter.route(sql)) {
            PreparedStatement preparedStatement = connection.getConnection(each).prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            this.routedStatements.add(preparedStatement);
        }
    }

    public MasterSlavePreparedStatement(MasterSlaveConnection connection, String sql, int autoGeneratedKeys) throws SQLException {
        this.connection = connection;
        this.masterSlaveRouter = new MasterSlaveRouter(connection.getMasterSlaveDataSource().getMasterSlaveRule(), ((Boolean)connection.getMasterSlaveDataSource().getShardingProperties().getValue(ShardingPropertiesConstant.SQL_SHOW)).booleanValue());
        for (String each : this.masterSlaveRouter.route(sql)) {
            PreparedStatement preparedStatement = connection.getConnection(each).prepareStatement(sql, autoGeneratedKeys);
            this.routedStatements.add(preparedStatement);
        }
    }

    public MasterSlavePreparedStatement(MasterSlaveConnection connection, String sql, int[] columnIndexes) throws SQLException {
        this.connection = connection;
        this.masterSlaveRouter = new MasterSlaveRouter(connection.getMasterSlaveDataSource().getMasterSlaveRule(), ((Boolean)connection.getMasterSlaveDataSource().getShardingProperties().getValue(ShardingPropertiesConstant.SQL_SHOW)).booleanValue());
        for (String each : this.masterSlaveRouter.route(sql)) {
            PreparedStatement preparedStatement = connection.getConnection(each).prepareStatement(sql, columnIndexes);
            this.routedStatements.add(preparedStatement);
        }
    }

    public MasterSlavePreparedStatement(MasterSlaveConnection connection, String sql, String[] columnNames) throws SQLException {
        this.connection = connection;
        this.masterSlaveRouter = new MasterSlaveRouter(connection.getMasterSlaveDataSource().getMasterSlaveRule(), ((Boolean)connection.getMasterSlaveDataSource().getShardingProperties().getValue(ShardingPropertiesConstant.SQL_SHOW)).booleanValue());
        for (String each : this.masterSlaveRouter.route(sql)) {
            PreparedStatement preparedStatement = connection.getConnection(each).prepareStatement(sql, columnNames);
            this.routedStatements.add(preparedStatement);
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        Preconditions.checkArgument((1 == this.routedStatements.size() ? 1 : 0) != 0, (Object)"Cannot support executeQuery for DDL");
        return this.routedStatements.iterator().next().executeQuery();
    }

    @Override
    public int executeUpdate() throws SQLException {
        int result = 0;
        for (PreparedStatement each : this.routedStatements) {
            result += each.executeUpdate();
        }
        return result;
    }

    @Override
    public boolean execute() throws SQLException {
        boolean result = false;
        for (PreparedStatement each : this.routedStatements) {
            result = each.execute();
        }
        return result;
    }

    @Override
    public void clearBatch() throws SQLException {
        Preconditions.checkArgument((1 == this.routedStatements.size() ? 1 : 0) != 0, (Object)"Cannot support clearBatch for DDL");
        this.routedStatements.iterator().next().clearBatch();
    }

    @Override
    public void addBatch() throws SQLException {
        Preconditions.checkArgument((1 == this.routedStatements.size() ? 1 : 0) != 0, (Object)"Cannot support addBatch for DDL");
        this.routedStatements.iterator().next().addBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        Preconditions.checkArgument((1 == this.routedStatements.size() ? 1 : 0) != 0, (Object)"Cannot support executeBatch for DDL");
        return this.routedStatements.iterator().next().executeBatch();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        Preconditions.checkArgument((1 == this.routedStatements.size() ? 1 : 0) != 0, (Object)"Cannot support getResultSet for DDL");
        return this.routedStatements.iterator().next().getResultSet();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        Preconditions.checkArgument((1 == this.routedStatements.size() ? 1 : 0) != 0, (Object)"Cannot support getGeneratedKeys for DDL");
        return this.routedStatements.iterator().next().getGeneratedKeys();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.routedStatements.iterator().next().getResultSetHoldability();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.routedStatements.iterator().next().getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.routedStatements.iterator().next().getResultSetType();
    }

    @Override
    public boolean isAccumulate() {
        return false;
    }

    @Override
    public MasterSlaveConnection getConnection() {
        return this.connection;
    }

    public Collection<PreparedStatement> getRoutedStatements() {
        return this.routedStatements;
    }
}

