/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.jdbc.core.statement;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Collections2;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.shardingsphere.core.PreparedQueryShardingEngine;
import org.apache.shardingsphere.core.constant.DatabaseType;
import org.apache.shardingsphere.core.execute.sql.execute.result.StreamQueryResult;
import org.apache.shardingsphere.core.merge.MergeEngine;
import org.apache.shardingsphere.core.merge.MergeEngineFactory;
import org.apache.shardingsphere.core.metadata.table.ShardingTableMetaData;
import org.apache.shardingsphere.core.optimize.GeneratedKey;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dal.DALStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.DQLStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.InsertStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.SelectStatement;
import org.apache.shardingsphere.core.route.SQLRouteResult;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.shardingjdbc.executor.BatchPreparedStatementExecutor;
import org.apache.shardingsphere.shardingjdbc.executor.PreparedStatementExecutor;
import org.apache.shardingsphere.shardingjdbc.jdbc.adapter.AbstractShardingPreparedStatementAdapter;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.ShardingContext;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.connection.ShardingConnection;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.resultset.GeneratedKeysResultSet;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.resultset.ShardingResultSet;

public final class ShardingPreparedStatement
extends AbstractShardingPreparedStatementAdapter {
    private final ShardingConnection connection;
    private final String sql;
    private final PreparedQueryShardingEngine shardingEngine;
    private final PreparedStatementExecutor preparedStatementExecutor;
    private final BatchPreparedStatementExecutor batchPreparedStatementExecutor;
    private SQLRouteResult routeResult;
    private ResultSet currentResultSet;

    public ShardingPreparedStatement(ShardingConnection connection, String sql) {
        this(connection, sql, 1003, 1007, 1, false);
    }

    public ShardingPreparedStatement(ShardingConnection connection, String sql, int resultSetType, int resultSetConcurrency) {
        this(connection, sql, resultSetType, resultSetConcurrency, 1, false);
    }

    public ShardingPreparedStatement(ShardingConnection connection, String sql, int autoGeneratedKeys) {
        this(connection, sql, 1003, 1007, 1, 1 == autoGeneratedKeys);
    }

    public ShardingPreparedStatement(ShardingConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability, false);
    }

    private ShardingPreparedStatement(ShardingConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, boolean returnGeneratedKeys) {
        this.connection = connection;
        this.sql = sql;
        ShardingContext shardingContext = connection.getShardingContext();
        this.shardingEngine = new PreparedQueryShardingEngine(sql, shardingContext.getShardingRule(), shardingContext.getShardingProperties(), shardingContext.getMetaData(), shardingContext.getDatabaseType(), shardingContext.getParsingResultCache());
        this.preparedStatementExecutor = new PreparedStatementExecutor(resultSetType, resultSetConcurrency, resultSetHoldability, returnGeneratedKeys, connection);
        this.batchPreparedStatementExecutor = new BatchPreparedStatementExecutor(resultSetType, resultSetConcurrency, resultSetHoldability, returnGeneratedKeys, connection);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        ShardingResultSet result;
        try {
            this.clearPrevious();
            this.shard();
            this.initPreparedStatementExecutor();
            MergeEngine mergeEngine = MergeEngineFactory.newInstance((DatabaseType)this.connection.getShardingContext().getDatabaseType(), (ShardingRule)this.connection.getShardingContext().getShardingRule(), (SQLRouteResult)this.routeResult, (ShardingTableMetaData)this.connection.getShardingContext().getMetaData().getTable(), this.preparedStatementExecutor.executeQuery());
            result = this.getResultSet(mergeEngine);
        }
        finally {
            this.clearBatch();
        }
        this.currentResultSet = result;
        return result;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (null != this.currentResultSet) {
            return this.currentResultSet;
        }
        if (1 == this.preparedStatementExecutor.getStatements().size() && this.routeResult.getSqlStatement() instanceof DQLStatement) {
            this.currentResultSet = this.preparedStatementExecutor.getStatements().iterator().next().getResultSet();
            return this.currentResultSet;
        }
        ArrayList<ResultSet> resultSets = new ArrayList<ResultSet>(this.preparedStatementExecutor.getStatements().size());
        ArrayList<StreamQueryResult> queryResults = new ArrayList<StreamQueryResult>(this.preparedStatementExecutor.getStatements().size());
        for (Statement each : this.preparedStatementExecutor.getStatements()) {
            ResultSet resultSet = each.getResultSet();
            resultSets.add(resultSet);
            ShardingRule shardingRule = this.connection.getShardingContext().getShardingRule();
            queryResults.add(new StreamQueryResult(resultSet, shardingRule, shardingRule.getShardingEncryptorEngine()));
        }
        if (this.routeResult.getSqlStatement() instanceof SelectStatement || this.routeResult.getSqlStatement() instanceof DALStatement) {
            MergeEngine mergeEngine = MergeEngineFactory.newInstance((DatabaseType)this.connection.getShardingContext().getDatabaseType(), (ShardingRule)this.connection.getShardingContext().getShardingRule(), (SQLRouteResult)this.routeResult, (ShardingTableMetaData)this.connection.getShardingContext().getMetaData().getTable(), queryResults);
            this.currentResultSet = this.getCurrentResultSet(resultSets, mergeEngine);
        }
        return this.currentResultSet;
    }

    private ShardingResultSet getResultSet(MergeEngine mergeEngine) throws SQLException {
        return this.getCurrentResultSet(this.preparedStatementExecutor.getResultSets(), mergeEngine);
    }

    private ShardingResultSet getCurrentResultSet(List<ResultSet> resultSets, MergeEngine mergeEngine) throws SQLException {
        return new ShardingResultSet(resultSets, mergeEngine.merge(), this);
    }

    @Override
    public int executeUpdate() throws SQLException {
        try {
            this.clearPrevious();
            this.shard();
            this.initPreparedStatementExecutor();
            int n = this.preparedStatementExecutor.executeUpdate();
            return n;
        }
        finally {
            this.clearBatch();
        }
    }

    @Override
    public boolean execute() throws SQLException {
        try {
            this.clearPrevious();
            this.shard();
            this.initPreparedStatementExecutor();
            boolean bl = this.preparedStatementExecutor.execute();
            return bl;
        }
        finally {
            this.clearBatch();
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        Optional<GeneratedKey> generatedKey = this.getGeneratedKey();
        if (this.preparedStatementExecutor.isReturnGeneratedKeys() && generatedKey.isPresent()) {
            return new GeneratedKeysResultSet(this.routeResult.getGeneratedKey().getGeneratedKeys().iterator(), ((GeneratedKey)generatedKey.get()).getColumnName(), this);
        }
        if (1 == this.preparedStatementExecutor.getStatements().size()) {
            return this.preparedStatementExecutor.getStatements().iterator().next().getGeneratedKeys();
        }
        return new GeneratedKeysResultSet();
    }

    private Optional<GeneratedKey> getGeneratedKey() {
        if (null != this.routeResult && this.routeResult.getSqlStatement() instanceof InsertStatement) {
            return Optional.fromNullable((Object)this.routeResult.getGeneratedKey());
        }
        return Optional.absent();
    }

    private void initPreparedStatementExecutor() throws SQLException {
        this.preparedStatementExecutor.init(this.routeResult);
        this.setParametersForStatements();
    }

    private void setParametersForStatements() {
        for (int i = 0; i < this.preparedStatementExecutor.getStatements().size(); ++i) {
            this.replaySetParameter((PreparedStatement)this.preparedStatementExecutor.getStatements().get(i), this.preparedStatementExecutor.getParameterSets().get(i));
        }
    }

    private void clearPrevious() throws SQLException {
        this.preparedStatementExecutor.clear();
    }

    @Override
    public void addBatch() {
        try {
            this.shard();
            this.batchPreparedStatementExecutor.addBatchForRouteUnits(this.routeResult);
        }
        finally {
            this.currentResultSet = null;
            this.clearParameters();
        }
    }

    private void shard() {
        this.routeResult = this.shardingEngine.shard(this.sql, this.getParameters());
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try {
            this.initBatchPreparedStatementExecutor();
            int[] nArray = this.batchPreparedStatementExecutor.executeBatch();
            return nArray;
        }
        finally {
            this.clearBatch();
        }
    }

    private void initBatchPreparedStatementExecutor() throws SQLException {
        this.batchPreparedStatementExecutor.init(this.routeResult);
        this.setBatchParametersForStatements();
    }

    private void setBatchParametersForStatements() throws SQLException {
        for (Statement each : this.batchPreparedStatementExecutor.getStatements()) {
            List<List<Object>> parameterSet = this.batchPreparedStatementExecutor.getParameterSet(each);
            for (List<Object> parameters : parameterSet) {
                this.replaySetParameter((PreparedStatement)each, parameters);
                ((PreparedStatement)each).addBatch();
            }
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.currentResultSet = null;
        this.batchPreparedStatementExecutor.clear();
        this.clearParameters();
    }

    @Override
    public int getResultSetType() {
        return this.preparedStatementExecutor.getResultSetType();
    }

    @Override
    public int getResultSetConcurrency() {
        return this.preparedStatementExecutor.getResultSetConcurrency();
    }

    @Override
    public int getResultSetHoldability() {
        return this.preparedStatementExecutor.getResultSetHoldability();
    }

    @Override
    public boolean isAccumulate() {
        return !this.connection.getShardingContext().getShardingRule().isAllBroadcastTables(this.routeResult.getSqlStatement().getTables().getTableNames());
    }

    public Collection<PreparedStatement> getRoutedStatements() {
        return Collections2.transform(this.preparedStatementExecutor.getStatements(), (Function)new Function<Statement, PreparedStatement>(){

            public PreparedStatement apply(Statement input) {
                return (PreparedStatement)input;
            }
        });
    }

    @Override
    public ShardingConnection getConnection() {
        return this.connection;
    }
}

