/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.jdbc.core.statement;

import com.google.common.base.Optional;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.shardingsphere.core.SimpleQueryShardingEngine;
import org.apache.shardingsphere.core.constant.DatabaseType;
import org.apache.shardingsphere.core.execute.sql.execute.result.StreamQueryResult;
import org.apache.shardingsphere.core.merge.MergeEngine;
import org.apache.shardingsphere.core.merge.MergeEngineFactory;
import org.apache.shardingsphere.core.metadata.table.ShardingTableMetaData;
import org.apache.shardingsphere.core.optimize.GeneratedKey;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dal.DALStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.DQLStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.InsertStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.SelectStatement;
import org.apache.shardingsphere.core.route.SQLRouteResult;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.shardingjdbc.executor.StatementExecutor;
import org.apache.shardingsphere.shardingjdbc.jdbc.adapter.AbstractStatementAdapter;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.ShardingContext;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.connection.ShardingConnection;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.resultset.GeneratedKeysResultSet;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.resultset.ShardingResultSet;

public final class ShardingStatement
extends AbstractStatementAdapter {
    private final ShardingConnection connection;
    private final StatementExecutor statementExecutor;
    private boolean returnGeneratedKeys;
    private SQLRouteResult routeResult;
    private ResultSet currentResultSet;

    public ShardingStatement(ShardingConnection connection) {
        this(connection, 1003, 1007, 1);
    }

    public ShardingStatement(ShardingConnection connection, int resultSetType, int resultSetConcurrency) {
        this(connection, resultSetType, resultSetConcurrency, 1);
    }

    public ShardingStatement(ShardingConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        super(Statement.class);
        this.connection = connection;
        this.statementExecutor = new StatementExecutor(resultSetType, resultSetConcurrency, resultSetHoldability, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        ShardingResultSet result;
        try {
            this.clearPrevious();
            this.shard(sql);
            this.initStatementExecutor();
            MergeEngine mergeEngine = MergeEngineFactory.newInstance((DatabaseType)this.connection.getShardingContext().getDatabaseType(), (ShardingRule)this.connection.getShardingContext().getShardingRule(), (SQLRouteResult)this.routeResult, (ShardingTableMetaData)this.connection.getShardingContext().getMetaData().getTable(), this.statementExecutor.executeQuery());
            result = this.getResultSet(mergeEngine);
        }
        finally {
            this.currentResultSet = null;
        }
        this.currentResultSet = result;
        return result;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (null != this.currentResultSet) {
            return this.currentResultSet;
        }
        if (1 == this.statementExecutor.getStatements().size() && this.routeResult.getSqlStatement() instanceof DQLStatement) {
            this.currentResultSet = this.statementExecutor.getStatements().iterator().next().getResultSet();
            return this.currentResultSet;
        }
        ArrayList<ResultSet> resultSets = new ArrayList<ResultSet>(this.statementExecutor.getStatements().size());
        ArrayList<StreamQueryResult> queryResults = new ArrayList<StreamQueryResult>(this.statementExecutor.getStatements().size());
        for (Statement each : this.statementExecutor.getStatements()) {
            ResultSet resultSet = each.getResultSet();
            resultSets.add(resultSet);
            ShardingRule shardingRule = this.connection.getShardingContext().getShardingRule();
            queryResults.add(new StreamQueryResult(resultSet, shardingRule, shardingRule.getShardingEncryptorEngine()));
        }
        if (this.routeResult.getSqlStatement() instanceof SelectStatement || this.routeResult.getSqlStatement() instanceof DALStatement) {
            MergeEngine mergeEngine = MergeEngineFactory.newInstance((DatabaseType)this.connection.getShardingContext().getDatabaseType(), (ShardingRule)this.connection.getShardingContext().getShardingRule(), (SQLRouteResult)this.routeResult, (ShardingTableMetaData)this.connection.getShardingContext().getMetaData().getTable(), queryResults);
            this.currentResultSet = this.getCurrentResultSet(resultSets, mergeEngine);
        }
        return this.currentResultSet;
    }

    private ShardingResultSet getResultSet(MergeEngine mergeEngine) throws SQLException {
        return this.getCurrentResultSet(this.statementExecutor.getResultSets(), mergeEngine);
    }

    private ShardingResultSet getCurrentResultSet(List<ResultSet> resultSets, MergeEngine mergeEngine) throws SQLException {
        return new ShardingResultSet(resultSets, mergeEngine.merge(), this);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        try {
            this.clearPrevious();
            this.shard(sql);
            this.initStatementExecutor();
            int n = this.statementExecutor.executeUpdate();
            return n;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (1 == autoGeneratedKeys) {
            this.returnGeneratedKeys = true;
        }
        try {
            this.clearPrevious();
            this.shard(sql);
            this.initStatementExecutor();
            int n = this.statementExecutor.executeUpdate(autoGeneratedKeys);
            return n;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.returnGeneratedKeys = true;
        try {
            this.clearPrevious();
            this.shard(sql);
            this.initStatementExecutor();
            int n = this.statementExecutor.executeUpdate(columnIndexes);
            return n;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.returnGeneratedKeys = true;
        try {
            this.clearPrevious();
            this.shard(sql);
            this.initStatementExecutor();
            int n = this.statementExecutor.executeUpdate(columnNames);
            return n;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        try {
            this.clearPrevious();
            this.shard(sql);
            this.initStatementExecutor();
            boolean bl = this.statementExecutor.execute();
            return bl;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        if (1 == autoGeneratedKeys) {
            this.returnGeneratedKeys = true;
        }
        try {
            this.clearPrevious();
            this.shard(sql);
            this.initStatementExecutor();
            boolean bl = this.statementExecutor.execute(autoGeneratedKeys);
            return bl;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.returnGeneratedKeys = true;
        try {
            this.clearPrevious();
            this.shard(sql);
            this.initStatementExecutor();
            boolean bl = this.statementExecutor.execute(columnIndexes);
            return bl;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.returnGeneratedKeys = true;
        try {
            this.clearPrevious();
            this.shard(sql);
            this.initStatementExecutor();
            boolean bl = this.statementExecutor.execute(columnNames);
            return bl;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    private void initStatementExecutor() throws SQLException {
        this.statementExecutor.init(this.routeResult);
        this.replayMethodForStatements();
    }

    private void replayMethodForStatements() {
        for (Statement each : this.statementExecutor.getStatements()) {
            this.replayMethodsInvocation(each);
        }
    }

    private void shard(String sql) {
        ShardingContext shardingContext = this.connection.getShardingContext();
        SimpleQueryShardingEngine shardingEngine = new SimpleQueryShardingEngine(shardingContext.getShardingRule(), shardingContext.getShardingProperties(), shardingContext.getMetaData(), shardingContext.getDatabaseType(), shardingContext.getParsingResultCache());
        this.routeResult = shardingEngine.shard(sql, Collections.emptyList());
    }

    private void clearPrevious() throws SQLException {
        this.statementExecutor.clear();
    }

    @Override
    public int getResultSetType() {
        return this.statementExecutor.getResultSetType();
    }

    @Override
    public int getResultSetConcurrency() {
        return this.statementExecutor.getResultSetConcurrency();
    }

    @Override
    public int getResultSetHoldability() {
        return this.statementExecutor.getResultSetHoldability();
    }

    @Override
    public boolean isAccumulate() {
        return !this.connection.getShardingContext().getShardingRule().isAllBroadcastTables(this.routeResult.getSqlStatement().getTables().getTableNames());
    }

    public Collection<Statement> getRoutedStatements() {
        return this.statementExecutor.getStatements();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        Optional<GeneratedKey> generatedKey = this.getGeneratedKey();
        if (this.returnGeneratedKeys && generatedKey.isPresent()) {
            return new GeneratedKeysResultSet(this.routeResult.getGeneratedKey().getGeneratedKeys().iterator(), ((GeneratedKey)generatedKey.get()).getColumnName(), this);
        }
        if (1 == this.getRoutedStatements().size()) {
            return this.getRoutedStatements().iterator().next().getGeneratedKeys();
        }
        return new GeneratedKeysResultSet();
    }

    private Optional<GeneratedKey> getGeneratedKey() {
        if (null != this.routeResult && this.routeResult.getSqlStatement() instanceof InsertStatement) {
            return Optional.fromNullable((Object)this.routeResult.getGeneratedKey());
        }
        return Optional.absent();
    }

    @Override
    public ShardingConnection getConnection() {
        return this.connection;
    }
}

