/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.exception.core.external.sql;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.exception.core.external.ShardingSphereExternalException;
import org.apache.shardingsphere.infra.exception.core.external.sql.sqlstate.SQLState;

public abstract class ShardingSphereSQLException
extends ShardingSphereExternalException {
    private static final long serialVersionUID = -8238061892944243621L;
    private final String sqlState;
    private final int vendorCode;
    private final String reason;
    private final Exception cause;

    protected ShardingSphereSQLException(SQLState sqlState, int typeOffset, int errorCode, String reason, Object ... messageArgs) {
        this(sqlState.getValue(), typeOffset, errorCode, reason, messageArgs);
    }

    protected ShardingSphereSQLException(String sqlState, int typeOffset, int errorCode, String reason, Object ... messageArgs) {
        this(sqlState, typeOffset, errorCode, null == reason ? null : String.format(reason, ShardingSphereSQLException.formatMessageArguments(messageArgs)), null);
    }

    protected ShardingSphereSQLException(String sqlState, int typeOffset, int errorCode, String reason, Exception cause) {
        super(reason, cause);
        this.sqlState = sqlState;
        Preconditions.checkArgument((typeOffset >= 0 && typeOffset < 4 ? 1 : 0) != 0, (Object)"The value range of type offset should be [0, 3].");
        Preconditions.checkArgument((errorCode >= 0 && errorCode < 10000 ? 1 : 0) != 0, (Object)"The value range of error code should be [0, 10000).");
        this.vendorCode = typeOffset * 10000 + errorCode;
        this.reason = null == cause || Strings.isNullOrEmpty((String)cause.getMessage()) ? reason : String.format("%s%sMore details: %s", reason, System.lineSeparator(), cause.getMessage());
        this.cause = cause;
    }

    private static Object[] formatMessageArguments(Object ... messageArgs) {
        return Arrays.stream(messageArgs).map(each -> each instanceof Collection ? ((Collection)each).stream().map(Object::toString).collect(Collectors.joining(", ")) : each).toArray(Object[]::new);
    }

    public final SQLException toSQLException() {
        return new SQLException(this.reason, this.sqlState, this.vendorCode, this.cause);
    }
}

