/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.exception.core.external.sql.type.kernel;

import com.google.common.base.Preconditions;
import org.apache.shardingsphere.infra.exception.core.external.sql.ShardingSphereSQLException;
import org.apache.shardingsphere.infra.exception.core.external.sql.sqlstate.SQLState;

public abstract class KernelSQLException
extends ShardingSphereSQLException {
    private static final long serialVersionUID = -6554922589499988153L;
    private static final int TYPE_OFFSET = 1;

    protected KernelSQLException(SQLState sqlState, int kernelCode, int errorCode, String reason, Object ... messageArgs) {
        super(sqlState, 1, KernelSQLException.getErrorCode(kernelCode, errorCode), reason, messageArgs);
    }

    protected KernelSQLException(SQLState sqlState, int kernelCode, int errorCode, String reason, Exception cause) {
        super(sqlState.getValue(), 1, KernelSQLException.getErrorCode(kernelCode, errorCode), reason, cause);
    }

    private static int getErrorCode(int kernelCode, int errorCode) {
        Preconditions.checkArgument((kernelCode >= 0 && kernelCode < 10 ? 1 : 0) != 0, (Object)"The value range of kernel code should be [0, 10).");
        Preconditions.checkArgument((errorCode >= 0 && errorCode < 1000 ? 1 : 0) != 0, (Object)"The value range of error code should be [0, 1000).");
        return kernelCode * 1000 + errorCode;
    }
}

