/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.cluster.plugin.nacos;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.skywalking.oap.server.cluster.plugin.nacos.ClusterModuleNacosConfig;
import org.apache.skywalking.oap.server.core.cluster.ClusterNodesQuery;
import org.apache.skywalking.oap.server.core.cluster.ClusterRegister;
import org.apache.skywalking.oap.server.core.cluster.RemoteInstance;
import org.apache.skywalking.oap.server.core.cluster.ServiceQueryException;
import org.apache.skywalking.oap.server.core.cluster.ServiceRegisterException;
import org.apache.skywalking.oap.server.core.remote.client.Address;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;

public class NacosCoordinator
implements ClusterRegister,
ClusterNodesQuery {
    private final NamingService namingService;
    private final ClusterModuleNacosConfig config;
    private volatile Address selfAddress;

    public NacosCoordinator(NamingService namingService, ClusterModuleNacosConfig config) {
        this.namingService = namingService;
        this.config = config;
    }

    public List<RemoteInstance> queryRemoteNodes() {
        ArrayList<RemoteInstance> result = new ArrayList<RemoteInstance>();
        try {
            List instances = this.namingService.selectInstances(this.config.getServiceName(), true);
            if (CollectionUtils.isNotEmpty((List)instances)) {
                instances.forEach(instance -> {
                    if (Objects.nonNull(this.selfAddress)) {
                        if (this.selfAddress.getHost().equals(instance.getIp()) && this.selfAddress.getPort() == instance.getPort()) {
                            result.add(new RemoteInstance(new Address(instance.getIp(), instance.getPort(), true)));
                        } else {
                            result.add(new RemoteInstance(new Address(instance.getIp(), instance.getPort(), false)));
                        }
                    }
                });
            }
        }
        catch (NacosException e) {
            throw new ServiceQueryException(e.getErrMsg());
        }
        return result;
    }

    public void registerRemote(RemoteInstance remoteInstance) throws ServiceRegisterException {
        String host = remoteInstance.getAddress().getHost();
        int port = remoteInstance.getAddress().getPort();
        try {
            this.namingService.registerInstance(this.config.getServiceName(), host, port);
        }
        catch (Exception e) {
            throw new ServiceRegisterException(e.getMessage());
        }
        this.selfAddress = remoteInstance.getAddress();
    }
}

