/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.server.jetty;

import com.google.gson.JsonElement;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Objects;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.skywalking.oap.server.library.server.jetty.ArgumentsParseException;
import org.apache.skywalking.oap.server.library.server.jetty.JettyHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JettyJsonHandler
extends JettyHandler {
    private static final Logger logger = LoggerFactory.getLogger(JettyHandler.class);

    protected final void doGet(HttpServletRequest req, HttpServletResponse resp) {
        try {
            this.reply(resp, this.doGet(req));
        }
        catch (IOException | ArgumentsParseException e) {
            try {
                this.replyError(resp, e.getMessage(), 400);
            }
            catch (IOException replyException) {
                logger.error(replyException.getMessage(), (Throwable)e);
            }
        }
    }

    protected abstract JsonElement doGet(HttpServletRequest var1) throws ArgumentsParseException;

    protected final void doPost(HttpServletRequest req, HttpServletResponse resp) {
        try {
            this.reply(resp, this.doPost(req));
        }
        catch (IOException | ArgumentsParseException e) {
            try {
                this.replyError(resp, e.getMessage(), 400);
            }
            catch (IOException replyException) {
                logger.error(replyException.getMessage(), (Throwable)e);
            }
        }
    }

    protected abstract JsonElement doPost(HttpServletRequest var1) throws ArgumentsParseException, IOException;

    protected final void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doHead(req, resp);
    }

    protected final long getLastModified(HttpServletRequest req) {
        return super.getLastModified(req);
    }

    protected final void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPut(req, resp);
    }

    protected final void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doDelete(req, resp);
    }

    protected final void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doOptions(req, resp);
    }

    protected final void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doTrace(req, resp);
    }

    protected final void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.service(req, resp);
    }

    public final void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        super.service(req, res);
    }

    public final void destroy() {
        super.destroy();
    }

    public final String getInitParameter(String name) {
        return super.getInitParameter(name);
    }

    public final Enumeration<String> getInitParameterNames() {
        return super.getInitParameterNames();
    }

    public final ServletConfig getServletConfig() {
        return super.getServletConfig();
    }

    public final ServletContext getServletContext() {
        return super.getServletContext();
    }

    public final String getServletInfo() {
        return super.getServletInfo();
    }

    public final void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public final void init() throws ServletException {
        super.init();
    }

    public final void log(String msg) {
        super.log(msg);
    }

    public final void log(String message, Throwable t) {
        super.log(message, t);
    }

    public final String getServletName() {
        return super.getServletName();
    }

    private void reply(HttpServletResponse response, JsonElement resJson) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        response.setStatus(200);
        PrintWriter out = response.getWriter();
        if (Objects.nonNull(resJson)) {
            out.print(resJson);
        }
        out.flush();
        out.close();
    }

    private void replyError(HttpServletResponse response, String errorMessage, int status) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        response.setStatus(status);
        response.setHeader("error-message", errorMessage);
        PrintWriter out = response.getWriter();
        out.flush();
        out.close();
    }
}

