/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.persist;

import co.cask.tephra.persist.TransactionEditCodecs;
import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.apache.hadoop.io.Writable;
import org.apache.tephra.ChangeId;
import org.apache.tephra.TransactionType;

@Deprecated
public class TransactionEdit
implements Writable {
    private long writePointer;
    private long visibilityUpperBound;
    private long commitPointer;
    private long expirationDate;
    private State state;
    private Set<ChangeId> changes;
    private boolean canCommit;
    private TransactionType type;
    private Set<Long> truncateInvalidTx;
    private long truncateInvalidTxTime;
    private long parentWritePointer;
    private long[] checkpointPointers;

    public TransactionEdit() {
        this.changes = Sets.newHashSet();
        this.truncateInvalidTx = Sets.newHashSet();
    }

    TransactionEdit(long writePointer, long visibilityUpperBound, State state, long expirationDate, Set<ChangeId> changes, long commitPointer, boolean canCommit, TransactionType type, Set<Long> truncateInvalidTx2, long truncateInvalidTxTime, long parentWritePointer, long[] checkpointPointers) {
        this.writePointer = writePointer;
        this.visibilityUpperBound = visibilityUpperBound;
        this.state = state;
        this.expirationDate = expirationDate;
        this.changes = changes != null ? changes : Collections.emptySet();
        this.commitPointer = commitPointer;
        this.canCommit = canCommit;
        this.type = type;
        this.truncateInvalidTx = truncateInvalidTx2 != null ? truncateInvalidTx2 : Collections.emptySet();
        this.truncateInvalidTxTime = truncateInvalidTxTime;
        this.parentWritePointer = parentWritePointer;
        this.checkpointPointers = checkpointPointers;
    }

    public long getWritePointer() {
        return this.writePointer;
    }

    void setWritePointer(long writePointer) {
        this.writePointer = writePointer;
    }

    public long getVisibilityUpperBound() {
        return this.visibilityUpperBound;
    }

    void setVisibilityUpperBound(long visibilityUpperBound) {
        this.visibilityUpperBound = visibilityUpperBound;
    }

    public State getState() {
        return this.state;
    }

    void setState(State state) {
        this.state = state;
    }

    public long getExpiration() {
        return this.expirationDate;
    }

    void setExpiration(long expirationDate) {
        this.expirationDate = expirationDate;
    }

    public Set<ChangeId> getChanges() {
        return this.changes;
    }

    void setChanges(Set<ChangeId> changes) {
        this.changes = changes;
    }

    public long getCommitPointer() {
        return this.commitPointer;
    }

    void setCommitPointer(long commitPointer) {
        this.commitPointer = commitPointer;
    }

    public boolean getCanCommit() {
        return this.canCommit;
    }

    void setCanCommit(boolean canCommit) {
        this.canCommit = canCommit;
    }

    public TransactionType getType() {
        return this.type;
    }

    void setType(TransactionType type) {
        this.type = type;
    }

    public Set<Long> getTruncateInvalidTx() {
        return this.truncateInvalidTx;
    }

    void setTruncateInvalidTx(Set<Long> truncateInvalidTx2) {
        this.truncateInvalidTx = truncateInvalidTx2;
    }

    public long getTruncateInvalidTxTime() {
        return this.truncateInvalidTxTime;
    }

    void setTruncateInvalidTxTime(long truncateInvalidTxTime) {
        this.truncateInvalidTxTime = truncateInvalidTxTime;
    }

    public long getParentWritePointer() {
        return this.parentWritePointer;
    }

    void setParentWritePointer(long parentWritePointer) {
        this.parentWritePointer = parentWritePointer;
    }

    public long[] getCheckpointPointers() {
        return this.checkpointPointers;
    }

    void setCheckpointPointers(long[] checkpointPointers) {
        this.checkpointPointers = checkpointPointers;
    }

    public static TransactionEdit createStarted(long writePointer, long visibilityUpperBound, long expirationDate, TransactionType type) {
        return new TransactionEdit(writePointer, visibilityUpperBound, State.INPROGRESS, expirationDate, null, 0L, false, type, null, 0L, 0L, null);
    }

    public static TransactionEdit createCommitting(long writePointer, Set<ChangeId> changes) {
        return new TransactionEdit(writePointer, 0L, State.COMMITTING, 0L, changes, 0L, false, null, null, 0L, 0L, null);
    }

    public static TransactionEdit createCommitted(long writePointer, Set<ChangeId> changes, long nextWritePointer, boolean canCommit) {
        return new TransactionEdit(writePointer, 0L, State.COMMITTED, 0L, changes, nextWritePointer, canCommit, null, null, 0L, 0L, null);
    }

    public static TransactionEdit createAborted(long writePointer, TransactionType type, long[] checkpointPointers) {
        return new TransactionEdit(writePointer, 0L, State.ABORTED, 0L, null, 0L, false, type, null, 0L, 0L, checkpointPointers);
    }

    public static TransactionEdit createInvalid(long writePointer) {
        return new TransactionEdit(writePointer, 0L, State.INVALID, 0L, null, 0L, false, null, null, 0L, 0L, null);
    }

    public static TransactionEdit createMoveWatermark(long writePointer) {
        return new TransactionEdit(writePointer, 0L, State.MOVE_WATERMARK, 0L, null, 0L, false, null, null, 0L, 0L, null);
    }

    public static TransactionEdit createTruncateInvalidTx(Set<Long> truncateInvalidTx2) {
        return new TransactionEdit(0L, 0L, State.TRUNCATE_INVALID_TX, 0L, null, 0L, false, null, truncateInvalidTx2, 0L, 0L, null);
    }

    public static TransactionEdit createTruncateInvalidTxBefore(long truncateInvalidTxTime) {
        return new TransactionEdit(0L, 0L, State.TRUNCATE_INVALID_TX, 0L, null, 0L, false, null, null, truncateInvalidTxTime, 0L, null);
    }

    public static TransactionEdit createCheckpoint(long writePointer, long parentWritePointer) {
        return new TransactionEdit(writePointer, 0L, State.CHECKPOINT, 0L, null, 0L, false, null, null, 0L, parentWritePointer, null);
    }

    public void write(DataOutput out) throws IOException {
        TransactionEditCodecs.encode(this, out);
    }

    public void readFields(DataInput in) throws IOException {
        TransactionEditCodecs.decode(this, in);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TransactionEdit)) {
            return false;
        }
        TransactionEdit that = (TransactionEdit)o;
        return Objects.equal((Object)this.writePointer, (Object)that.writePointer) && Objects.equal((Object)this.visibilityUpperBound, (Object)that.visibilityUpperBound) && Objects.equal((Object)this.commitPointer, (Object)that.commitPointer) && Objects.equal((Object)this.expirationDate, (Object)that.expirationDate) && Objects.equal((Object)((Object)this.state), (Object)((Object)that.state)) && Objects.equal(this.changes, that.changes) && Objects.equal((Object)this.canCommit, (Object)that.canCommit) && Objects.equal((Object)this.type, (Object)that.type) && Objects.equal(this.truncateInvalidTx, that.truncateInvalidTx) && Objects.equal((Object)this.truncateInvalidTxTime, (Object)that.truncateInvalidTxTime) && Objects.equal((Object)this.parentWritePointer, (Object)that.parentWritePointer) && Arrays.equals(this.checkpointPointers, that.checkpointPointers);
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.writePointer, this.visibilityUpperBound, this.commitPointer, this.expirationDate, this.state, this.changes, this.canCommit, this.type, this.parentWritePointer, this.checkpointPointers});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("writePointer", this.writePointer).add("visibilityUpperBound", this.visibilityUpperBound).add("commitPointer", this.commitPointer).add("expiration", this.expirationDate).add("state", (Object)this.state).add("changesSize", this.changes != null ? this.changes.size() : 0).add("canCommit", this.canCommit).add("type", (Object)this.type).add("truncateInvalidTx", this.truncateInvalidTx).add("truncateInvalidTxTime", this.truncateInvalidTxTime).add("parentWritePointer", this.parentWritePointer).add("checkpointPointers", (Object)this.checkpointPointers).toString();
    }

    public static enum State {
        INPROGRESS,
        COMMITTING,
        COMMITTED,
        INVALID,
        ABORTED,
        MOVE_WATERMARK,
        TRUNCATE_INVALID_TX,
        CHECKPOINT;

    }
}

