/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.coprocessor;

import com.google.common.util.concurrent.AbstractIdleService;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.tephra.metrics.TxMetricsCollector;
import org.apache.tephra.persist.HDFSTransactionStateStorage;
import org.apache.tephra.persist.TransactionStateStorage;
import org.apache.tephra.persist.TransactionVisibilityState;
import org.apache.tephra.snapshot.SnapshotCodecProvider;
import org.apache.tephra.util.ConfigurationFactory;

public class TransactionStateCache
extends AbstractIdleService
implements Configurable {
    private static final Log LOG = LogFactory.getLog(TransactionStateCache.class);
    private static final long CHECK_FREQUENCY = 15L;
    private Configuration hConf;
    private TransactionStateStorage storage;
    private volatile TransactionVisibilityState latestState;
    private Thread refreshService;
    private long lastRefresh;
    private long snapshotRefreshFrequency;
    private boolean initialized;

    public Configuration getConf() {
        return this.hConf;
    }

    public void setConf(Configuration conf) {
        this.hConf = conf;
    }

    protected void startUp() throws Exception {
        try {
            this.refreshState();
        }
        catch (IOException ioe) {
            LOG.info((Object)"Error refreshing transaction state cache.", (Throwable)ioe);
        }
        this.startRefreshService();
    }

    protected void shutDown() throws Exception {
        this.refreshService.interrupt();
        this.storage.stop();
    }

    private void tryInit() {
        try {
            Configuration conf = this.getSnapshotConfiguration();
            if (conf != null) {
                this.storage = new HDFSTransactionStateStorage(conf, new SnapshotCodecProvider(conf), new TxMetricsCollector());
                this.storage.startAndWait();
                this.snapshotRefreshFrequency = conf.getLong("data.tx.snapshot.interval", 300L) * 1000L;
                this.initialized = true;
            } else {
                LOG.info((Object)"Could not load configuration");
            }
        }
        catch (Exception e) {
            LOG.info((Object)"Failed to initialize TransactionStateCache due to: ", (Throwable)e);
        }
    }

    protected Configuration getSnapshotConfiguration() throws IOException {
        Configuration conf = new ConfigurationFactory().get(this.hConf);
        conf.unset("data.tx.snapshot.codecs");
        return conf;
    }

    private void reset() {
        this.storage.stop();
        this.lastRefresh = 0L;
        this.initialized = false;
    }

    private void startRefreshService() {
        this.refreshService = new Thread("tx-state-refresh"){

            @Override
            public void run() {
                while (!this.isInterrupted()) {
                    if (TransactionStateCache.this.latestState == null || System.currentTimeMillis() > TransactionStateCache.this.lastRefresh + TransactionStateCache.this.snapshotRefreshFrequency) {
                        try {
                            TransactionStateCache.this.refreshState();
                        }
                        catch (IOException ioe) {
                            LOG.info((Object)"Error refreshing transaction state cache.", (Throwable)ioe);
                        }
                    }
                    try {
                        TimeUnit.SECONDS.sleep(15L);
                    }
                    catch (InterruptedException ie) {
                        this.interrupt();
                        break;
                    }
                }
                LOG.info((Object)("Exiting thread " + this.getName()));
            }
        };
        this.refreshService.setDaemon(true);
        this.refreshService.start();
    }

    private void refreshState() throws IOException {
        if (!this.initialized) {
            this.tryInit();
        }
        if (this.initialized) {
            long now = System.currentTimeMillis();
            TransactionVisibilityState currentState = this.storage.getLatestTransactionVisibilityState();
            if (currentState != null) {
                if (currentState.getTimestamp() < now - 2L * this.snapshotRefreshFrequency) {
                    LOG.info((Object)"Current snapshot is old, will force a refresh on next run.");
                    this.reset();
                } else {
                    this.latestState = currentState;
                    LOG.info((Object)("Transaction state reloaded with snapshot from " + this.latestState.getTimestamp()));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Latest transaction snapshot: " + this.latestState.toString()));
                    }
                    this.lastRefresh = now;
                }
            } else {
                LOG.info((Object)"No transaction state found.");
            }
        }
    }

    @Nullable
    public TransactionVisibilityState getLatestState() {
        return this.latestState;
    }
}

