/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.distributed;

import com.google.common.primitives.Longs;
import org.apache.tephra.Transaction;
import org.apache.tephra.TransactionType;
import org.apache.tephra.distributed.thrift.TTransaction;
import org.apache.tephra.distributed.thrift.TTransactionType;
import org.apache.tephra.distributed.thrift.TVisibilityLevel;

public final class TransactionConverterUtils {
    private static final long[] EMPTY_LONG_ARRAY = new long[0];

    public static TTransaction wrap(Transaction tx) {
        return new TTransaction(tx.getTransactionId(), tx.getReadPointer(), Longs.asList((long[])tx.getInvalids()), Longs.asList((long[])tx.getInProgress()), tx.getFirstShortInProgress(), TransactionConverterUtils.getTTransactionType(tx.getType()), tx.getWritePointer(), Longs.asList((long[])tx.getCheckpointWritePointers()), TransactionConverterUtils.getTVisibilityLevel(tx.getVisibilityLevel()));
    }

    public static Transaction unwrap(TTransaction thriftTx) {
        return new Transaction(thriftTx.getReadPointer(), thriftTx.getTransactionId(), thriftTx.getWritePointer(), thriftTx.getInvalids() == null ? EMPTY_LONG_ARRAY : Longs.toArray(thriftTx.getInvalids()), thriftTx.getInProgress() == null ? EMPTY_LONG_ARRAY : Longs.toArray(thriftTx.getInProgress()), thriftTx.getFirstShort(), TransactionConverterUtils.getTransactionType(thriftTx.getType()), thriftTx.getCheckpointWritePointers() == null ? EMPTY_LONG_ARRAY : Longs.toArray(thriftTx.getCheckpointWritePointers()), TransactionConverterUtils.getVisibilityLevel(thriftTx.getVisibilityLevel()));
    }

    private static TransactionType getTransactionType(TTransactionType tType) {
        return tType == TTransactionType.SHORT ? TransactionType.SHORT : TransactionType.LONG;
    }

    private static TTransactionType getTTransactionType(TransactionType type) {
        return type == TransactionType.SHORT ? TTransactionType.SHORT : TTransactionType.LONG;
    }

    private static Transaction.VisibilityLevel getVisibilityLevel(TVisibilityLevel tLevel) {
        if (tLevel == null) {
            return Transaction.VisibilityLevel.SNAPSHOT;
        }
        switch (tLevel) {
            case SNAPSHOT: {
                return Transaction.VisibilityLevel.SNAPSHOT;
            }
            case SNAPSHOT_EXCLUDE_CURRENT: {
                return Transaction.VisibilityLevel.SNAPSHOT_EXCLUDE_CURRENT;
            }
            case SNAPSHOT_ALL: {
                return Transaction.VisibilityLevel.SNAPSHOT_ALL;
            }
        }
        throw new IllegalArgumentException("Unknown TVisibilityLevel: " + (Object)((Object)tLevel));
    }

    private static TVisibilityLevel getTVisibilityLevel(Transaction.VisibilityLevel level) {
        switch (level) {
            case SNAPSHOT: {
                return TVisibilityLevel.SNAPSHOT;
            }
            case SNAPSHOT_EXCLUDE_CURRENT: {
                return TVisibilityLevel.SNAPSHOT_EXCLUDE_CURRENT;
            }
            case SNAPSHOT_ALL: {
                return TVisibilityLevel.SNAPSHOT_ALL;
            }
        }
        throw new IllegalArgumentException("Unknown VisibilityLevel: " + level);
    }
}

