/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.inmemory;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.InputStream;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.tephra.InvalidTruncateTimeException;
import org.apache.tephra.Transaction;
import org.apache.tephra.TransactionCouldNotTakeSnapshotException;
import org.apache.tephra.TransactionSystemClient;
import org.apache.tephra.TransactionType;

public class DetachedTxSystemClient
implements TransactionSystemClient {
    private AtomicLong generator = new AtomicLong(System.currentTimeMillis() * 1000000L);

    @Override
    public Transaction startShort() {
        long wp = this.getWritePointer();
        return new Transaction(0x7FFFFFFFFFFFFFFEL, wp, new long[0], new long[0], Long.MAX_VALUE, TransactionType.SHORT);
    }

    private long getWritePointer() {
        long advanced;
        long now;
        long wp = this.generator.incrementAndGet();
        if (wp < (now = System.currentTimeMillis()) * 1000000L && this.generator.compareAndSet(wp, advanced = now * 1000000L)) {
            wp = advanced;
        }
        return wp;
    }

    @Override
    public Transaction startShort(int timeout) {
        return this.startShort();
    }

    @Override
    public Transaction startLong() {
        return this.startShort();
    }

    @Override
    public boolean canCommit(Transaction tx, Collection<byte[]> changeIds) {
        return true;
    }

    @Override
    public boolean commit(Transaction tx) {
        return true;
    }

    @Override
    public void abort(Transaction tx) {
    }

    @Override
    public boolean invalidate(long tx) {
        return true;
    }

    @Override
    public Transaction checkpoint(Transaction tx) {
        long newWritePointer = this.getWritePointer();
        LongArrayList newCheckpointPointers = new LongArrayList(tx.getCheckpointWritePointers());
        newCheckpointPointers.add(newWritePointer);
        return new Transaction(tx, newWritePointer, newCheckpointPointers.toLongArray());
    }

    @Override
    public InputStream getSnapshotInputStream() throws TransactionCouldNotTakeSnapshotException {
        throw new TransactionCouldNotTakeSnapshotException("Snapshot not implemented in detached transaction system client");
    }

    @Override
    public String status() {
        return "OK";
    }

    @Override
    public void resetState() {
    }

    @Override
    public boolean truncateInvalidTx(Set<Long> invalidTxIds) {
        return true;
    }

    @Override
    public boolean truncateInvalidTxBefore(long time) throws InvalidTruncateTimeException {
        return true;
    }

    @Override
    public int getInvalidSize() {
        return 0;
    }
}

