/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.persist;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Queue;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.tephra.persist.CommitMarkerCodec;
import org.apache.tephra.persist.TransactionEdit;
import org.apache.tephra.persist.TransactionLogReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDFSTransactionLogReaderV2
implements TransactionLogReader {
    private static final Logger LOG = LoggerFactory.getLogger(HDFSTransactionLogReaderV2.class);
    private final SequenceFile.Reader reader;
    private final Queue<co.cask.tephra.persist.TransactionEdit> transactionEdits;
    private final CommitMarkerCodec commitMarkerCodec;
    private final LongWritable key;
    private boolean closed;

    public HDFSTransactionLogReaderV2(SequenceFile.Reader reader) {
        this.reader = reader;
        this.transactionEdits = new ArrayDeque<co.cask.tephra.persist.TransactionEdit>();
        this.key = new LongWritable();
        this.commitMarkerCodec = new CommitMarkerCodec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            this.commitMarkerCodec.close();
        }
        finally {
            this.reader.close();
            this.closed = true;
        }
    }

    @Override
    public TransactionEdit next() throws IOException {
        return this.next(null);
    }

    @Override
    public TransactionEdit next(TransactionEdit reuse) throws IOException {
        if (this.closed) {
            return null;
        }
        if (!this.transactionEdits.isEmpty()) {
            return TransactionEdit.convertCaskTxEdit(this.transactionEdits.remove());
        }
        this.populateTransactionEdits();
        return TransactionEdit.convertCaskTxEdit(this.transactionEdits.poll());
    }

    private void populateTransactionEdits() throws IOException {
        int numEntries = 0;
        try {
            numEntries = this.commitMarkerCodec.readMarker(this.reader);
        }
        catch (EOFException e) {
            LOG.warn("Reached EOF in log while trying to read commit marker", (Throwable)e);
        }
        for (int i = 0; i < numEntries; ++i) {
            co.cask.tephra.persist.TransactionEdit edit = new co.cask.tephra.persist.TransactionEdit();
            try {
                if (!this.reader.next((Writable)this.key, (Writable)edit)) {
                    throw new EOFException("Attempt to read TransactionEdit failed.");
                }
                this.transactionEdits.add(edit);
                continue;
            }
            catch (EOFException e) {
                LOG.warn("Reached EOF in log before reading {} entries. Ignoring all {} edits since the last marker", new Object[]{numEntries, this.transactionEdits.size(), e});
                this.transactionEdits.clear();
            }
        }
    }
}

