/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.snapshot;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public final class BinaryDecoder {
    private final InputStream input;

    public BinaryDecoder(InputStream input) {
        this.input = input;
    }

    public int readInt() throws IOException {
        int val = 0;
        int shift = 0;
        int b = this.readByte();
        while (b > 127) {
            val ^= (b & 0x7F) << shift;
            shift += 7;
            b = this.readByte();
        }
        return (val ^= b << shift) >>> 1 ^ -(val & 1);
    }

    public long readLong() throws IOException {
        long val = 0L;
        int shift = 0;
        int b = this.readByte();
        while (b > 127) {
            val ^= (long)(b & 0x7F) << shift;
            shift += 7;
            b = this.readByte();
        }
        return (val ^= (long)b << shift) >>> 1 ^ -(val & 1L);
    }

    public byte[] readBytes() throws IOException {
        int byteRead;
        int toRead;
        byte[] bytes = new byte[toRead];
        for (toRead = this.readInt(); toRead > 0; toRead -= byteRead) {
            byteRead = this.input.read(bytes, bytes.length - toRead, toRead);
            if (byteRead != -1) continue;
            throw new EOFException();
        }
        return bytes;
    }

    private int readByte() throws IOException {
        int b = this.input.read();
        if (b == -1) {
            throw new EOFException();
        }
        return b;
    }
}

