/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.lang.reflect.Array;
import java.util.Map;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Index;
import org.assertj.core.data.Offset;
import org.assertj.core.error.ShouldHaveLineCount;
import org.assertj.core.error.ShouldHaveSameSizeAs;
import org.assertj.core.error.ShouldHaveSize;
import org.assertj.core.internal.CommonErrors;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Iterables;

final class CommonValidations {
    private static Failures failures = Failures.instance();

    private CommonValidations() {
    }

    static void checkIndexValueIsValid(Index index, int maximum) {
        if (index == null) {
            throw new NullPointerException("Index should not be null");
        }
        if (index.value <= maximum) {
            return;
        }
        String errorMessage = "Index should be between <%d> and <%d> (inclusive,) but was:\n <%d>";
        throw new IndexOutOfBoundsException(String.format(errorMessage, 0, maximum, index.value));
    }

    static void checkOffsetIsNotNull(Offset<?> offset) {
        if (offset == null) {
            throw new NullPointerException("The given offset should not be null");
        }
    }

    static void checkNumberIsNotNull(Number number) {
        if (number == null) {
            throw new NullPointerException("The given number should not be null");
        }
    }

    static void checkIsNotEmpty(Object[] values) {
        if (values.length == 0) {
            throw CommonErrors.arrayOfValuesToLookForIsEmpty();
        }
    }

    static void checkIsNotEmpty(Iterable<?> iterable) {
        if (!iterable.iterator().hasNext()) {
            throw CommonErrors.iterableOfValuesToLookForIsEmpty();
        }
    }

    static void checkIsNotNull(Object[] values) {
        if (values == null) {
            throw CommonErrors.arrayOfValuesToLookForIsNull();
        }
    }

    static void checkIsNotNull(Iterable<?> iterable) {
        if (iterable == null) {
            throw CommonErrors.iterableOfValuesForIsNull();
        }
    }

    static void checkIsNotNullAndNotEmpty(Object[] values) {
        CommonValidations.checkIsNotNull(values);
        CommonValidations.checkIsNotEmpty(values);
    }

    static void checkIsNotNullAndNotEmpty(Iterable<?> iterable) {
        CommonValidations.checkIsNotNull(iterable);
        CommonValidations.checkIsNotEmpty(iterable);
    }

    static void failIfEmptySinceActualIsNotEmpty(Object[] values) {
        if (values.length == 0) {
            throw new AssertionError((Object)"actual is not empty");
        }
    }

    public static void hasSameSizeAsCheck(AssertionInfo info, Object actual, Object other, int sizeOfActual) {
        CommonValidations.checkOtherIsNotNull(other, "Array");
        CommonValidations.checkSameSizes(info, actual, sizeOfActual, Array.getLength(other));
    }

    public static void hasSameSizeAsCheck(AssertionInfo info, Object actual, Iterable<?> other, int sizeOfActual) {
        CommonValidations.checkOtherIsNotNull(other, "Iterable");
        CommonValidations.checkSameSizes(info, actual, sizeOfActual, org.assertj.core.util.Iterables.sizeOf(other));
    }

    public static void hasSameSizeAsCheck(AssertionInfo info, Object actual, Map<?, ?> other, int sizeOfActual) {
        CommonValidations.checkOtherIsNotNull(other, "Map");
        CommonValidations.checkSameSizes(info, actual, sizeOfActual, other.size());
    }

    static void checkOtherIsNotNull(Object other, String otherType) {
        if (other == null) {
            throw new NullPointerException("The " + otherType + " to compare actual size with should not be null");
        }
    }

    static void checkSameSizes(AssertionInfo info, Object actual, int sizeOfActual, int sizeOfOther) {
        if (sizeOfActual != sizeOfOther) {
            throw failures.failure(info, ShouldHaveSameSizeAs.shouldHaveSameSizeAs(actual, sizeOfActual, sizeOfOther));
        }
    }

    public static void checkSizes(Object actual, int sizeOfActual, int sizeOfOther, AssertionInfo info) {
        if (sizeOfActual != sizeOfOther) {
            throw failures.failure(info, ShouldHaveSize.shouldHaveSize(actual, sizeOfActual, sizeOfOther));
        }
    }

    public static void checkLineCounts(Object actual, int lineCountOfActual, int lineCountOfOther, AssertionInfo info) {
        if (lineCountOfActual != lineCountOfOther) {
            throw failures.failure(info, ShouldHaveLineCount.shouldHaveLinesCount(actual, lineCountOfActual, lineCountOfOther));
        }
    }

    public static void checkTypeIsNotNull(Class<?> expectedType) {
        if (expectedType == null) {
            throw new NullPointerException("The given type should not be null");
        }
    }

    public static void checkIterableIsNotNull(AssertionInfo info, Iterable<?> set) {
        if (set == null) {
            throw Iterables.iterableToLookForIsNull();
        }
    }
}

