/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.adapter;

import dev.failsafe.ExecutionContext;
import dev.failsafe.Failsafe;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import javax.sql.DataSource;
import org.casbin.adapter.CasbinRule;
import org.casbin.adapter.JDBCBaseAdapter;
import org.casbin.jcasbin.exception.CasbinAdapterException;
import org.casbin.jcasbin.model.Model;
import org.casbin.jcasbin.persist.FilteredAdapter;
import org.casbin.jcasbin.persist.Helper;
import org.casbin.jcasbin.persist.file_adapter.FilteredAdapter;

public class JDBCAdapter
extends JDBCBaseAdapter
implements FilteredAdapter {
    private boolean isFiltered = false;

    public JDBCAdapter(String driver, String url, String username, String password) throws Exception {
        super(driver, url, username, password);
    }

    public JDBCAdapter(DataSource dataSource) throws Exception {
        super(dataSource);
    }

    public void loadFilteredPolicy(Model model, Object filter) throws CasbinAdapterException {
        if (filter == null) {
            this.loadPolicy(model);
            this.isFiltered = false;
            return;
        }
        if (!(filter instanceof FilteredAdapter.Filter)) {
            this.isFiltered = false;
            throw new CasbinAdapterException("Invalid filter type.");
        }
        try {
            this.loadFilteredPolicyFile(model, (FilteredAdapter.Filter)filter, (Helper.loadPolicyLineHandler<String, Model>)((Helper.loadPolicyLineHandler)Helper::loadPolicyLine));
            this.isFiltered = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isFiltered() {
        return this.isFiltered;
    }

    private void loadFilteredPolicyFile(Model model, FilteredAdapter.Filter filter, Helper.loadPolicyLineHandler<String, Model> handler) throws CasbinAdapterException {
        Failsafe.with((Policy)this.retryPolicy, (Policy[])new RetryPolicy[0]).run(ctx -> {
            if (ctx.isRetry()) {
                this.retry((ExecutionContext<Void>)ctx);
            }
            try (Statement stmt = this.conn.createStatement();
                 ResultSet rSet = stmt.executeQuery("SELECT * FROM casbin_rule");){
                ResultSetMetaData rData = rSet.getMetaData();
                while (rSet.next()) {
                    CasbinRule line = new CasbinRule();
                    for (int i = 1; i <= rData.getColumnCount(); ++i) {
                        if (i == 2) {
                            line.ptype = rSet.getObject(i) == null ? "" : (String)rSet.getObject(i);
                            continue;
                        }
                        if (i == 3) {
                            line.v0 = rSet.getObject(i) == null ? "" : (String)rSet.getObject(i);
                            continue;
                        }
                        if (i == 4) {
                            line.v1 = rSet.getObject(i) == null ? "" : (String)rSet.getObject(i);
                            continue;
                        }
                        if (i == 5) {
                            line.v2 = rSet.getObject(i) == null ? "" : (String)rSet.getObject(i);
                            continue;
                        }
                        if (i == 6) {
                            line.v3 = rSet.getObject(i) == null ? "" : (String)rSet.getObject(i);
                            continue;
                        }
                        if (i == 7) {
                            line.v4 = rSet.getObject(i) == null ? "" : (String)rSet.getObject(i);
                            continue;
                        }
                        if (i != 8) continue;
                        line.v5 = rSet.getObject(i) == null ? "" : (String)rSet.getObject(i);
                    }
                    if (this.filterLine(line, filter)) continue;
                    this.loadPolicyLine(line, model);
                }
            }
        });
    }

    private boolean filterLine(CasbinRule line, FilteredAdapter.Filter filter) {
        if (filter == null) {
            return false;
        }
        String[] filterSlice = null;
        switch (line.ptype.trim()) {
            case "p": {
                filterSlice = filter.p;
                break;
            }
            case "g": {
                filterSlice = filter.g;
            }
        }
        if (filterSlice == null) {
            filterSlice = new String[]{};
        }
        return this.filterWords(line.toStringArray(), filterSlice);
    }

    private boolean filterWords(String[] line, String[] filter) {
        boolean skipLine = false;
        int i = 0;
        for (String s : filter) {
            if (s.length() <= 0 || s.trim().equals(line[++i].trim())) continue;
            skipLine = true;
            break;
        }
        return skipLine;
    }
}

