/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.configuration.script;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.configuration.entry.Resource;
import org.codehaus.cargo.container.configuration.script.ScriptCommand;
import org.codehaus.cargo.container.internal.util.ResourceUtils;
import org.codehaus.cargo.util.AntUtils;
import org.codehaus.cargo.util.CargoException;

public abstract class AbstractScriptCommand
implements ScriptCommand {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private Configuration configuration;
    private String resourcePath;
    private ResourceUtils resourceUtils;
    private AntUtils antUtils;

    public AbstractScriptCommand(Configuration configuration, String resourcePath) {
        this.configuration = configuration;
        this.resourcePath = resourcePath;
        this.resourceUtils = new ResourceUtils();
        this.antUtils = new AntUtils();
    }

    @Override
    public String readScript() {
        FilterChain filterChain = new FilterChain();
        this.antUtils.addTokensToFilterChain(filterChain, this.configuration.getProperties());
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        this.addConfigurationScriptProperties(propertiesMap);
        this.antUtils.addTokensToFilterChain(filterChain, propertiesMap);
        String resourceName = this.resourcePath + this.getScriptRelativePath();
        try {
            return this.resourceUtils.readResource(resourceName, filterChain, StandardCharsets.UTF_8) + NEW_LINE;
        }
        catch (IOException e) {
            throw new CargoException("Error while reading resource [" + resourceName + "] ", (Throwable)e);
        }
    }

    @Override
    public boolean isApplicable() {
        return true;
    }

    protected abstract String getScriptRelativePath();

    protected void addConfigurationScriptProperties(Map<String, String> propertiesMap) {
    }

    protected Resource findResource(String type) {
        Resource foundResource = null;
        for (Resource resource : ((LocalConfiguration)this.configuration).getResources()) {
            if (!type.equals(resource.getType())) continue;
            foundResource = resource;
        }
        return foundResource;
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }
}

