/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.internal.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.tools.ant.util.StringUtils;

public final class PropertyUtils {
    private static final char PIPE = '|';
    private static final char SEMICOLON = ';';

    private PropertyUtils() {
    }

    public static Properties splitPropertiesOnPipe(String toSplit) {
        return PropertyUtils.splitPropertiesOnDelimiter(toSplit, '|');
    }

    public static Properties splitPropertiesOnSemicolon(String toSplit) {
        return PropertyUtils.splitPropertiesOnDelimiter(toSplit, ';');
    }

    public static Properties splitPropertiesOnDelimiter(String toSplit, char delimiter) {
        Properties properties = new Properties();
        String toSplitHalfEscaped = toSplit.replace("\\\\" + delimiter, "\\" + delimiter);
        String newLineSeparated = toSplitHalfEscaped.replaceAll("([^\\\\])" + Pattern.quote(String.valueOf(delimiter)), "$1\n");
        try {
            properties.load(new ByteArrayInputStream(newLineSeparated.getBytes(StandardCharsets.ISO_8859_1)));
            return properties;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String joinOnPipe(Map<String, String> toJoin) {
        return PropertyUtils.joinOnDelimiter(toJoin, '|');
    }

    public static String joinOnSemicolon(Map<String, String> toJoin) {
        return PropertyUtils.joinOnDelimiter(toJoin, ';');
    }

    public static String joinOnDelimiter(Map<String, String> toJoin, char delimiter) {
        StringBuilder buf = new StringBuilder();
        Iterator<Map.Entry<String, String>> it = toJoin.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> e = it.next();
            String key = e.getKey();
            String value = e.getValue();
            if (value.indexOf(delimiter) != -1) {
                value = value.replace(String.valueOf(delimiter), "\\" + delimiter);
            }
            buf.append(key);
            buf.append("=");
            buf.append(value);
            if (!it.hasNext()) continue;
            buf.append(delimiter);
        }
        return buf.toString();
    }

    public static void setPropertyIfNotNull(Properties properties, String property, Object value) {
        if (value != null) {
            properties.setProperty(property, value.toString());
        }
    }

    public static String escapeBackSlashesIfNotNull(String in) {
        if (in != null) {
            return StringUtils.replace((String)in, (String)"\\", (String)"\\\\");
        }
        return null;
    }

    public static Map<String, String> toMap(Properties properties) {
        HashMap<String, String> result = new HashMap<String, String>(properties.size());
        for (Map.Entry<Object, Object> parameter : properties.entrySet()) {
            String value = null;
            if (parameter.getValue() != null) {
                value = parameter.getValue().toString();
            }
            result.put(parameter.getKey().toString(), value);
        }
        return result;
    }
}

