/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.internal.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Vector;
import org.apache.tools.ant.filters.util.ChainReaderHelper;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.cargo.util.DefaultFileHandler;
import org.codehaus.cargo.util.FileHandler;
import org.codehaus.cargo.util.log.LoggedObject;

public final class ResourceUtils
extends LoggedObject {
    private static final int BUFFER_CHUNK_SIZE = 262144;
    private static FileHandler defaultFileHandler = new DefaultFileHandler();
    private static ClassLoader resourceLoader = ResourceUtils.class.getClassLoader();

    public static ClassLoader getResourceLoader() {
        return resourceLoader;
    }

    public static void setResourceLoader(ClassLoader resourceLoader) {
        ResourceUtils.resourceLoader = resourceLoader;
    }

    public void copyResource(String resourceName, File destFile) throws IOException {
        this.copyResource(resourceName, destFile.getPath(), defaultFileHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyResource(String resourceName, String destFile, FileHandler handler) throws IOException {
        InputStream in = resourceLoader.getResourceAsStream(resourceName);
        if (in == null) {
            throw new IOException("Resource [" + resourceName + "] not found in resource loader " + resourceLoader);
        }
        try (OutputStream out = handler.getOutputStream(destFile);){
            int numBytes;
            byte[] buf = new byte[4096];
            while ((numBytes = in.read(buf)) > 0) {
                out.write(buf, 0, numBytes);
            }
        }
        finally {
            in.close();
        }
    }

    public void copyResource(String resourceName, File destFile, FilterChain filterChain, Charset encoding) throws IOException {
        this.copyResource(resourceName, destFile.getPath(), defaultFileHandler, filterChain, encoding);
    }

    public void copyResource(String resourceName, String destFile, FileHandler handler, FilterChain filterChain, Charset encoding) throws IOException {
        InputStream resource = resourceLoader.getResourceAsStream(resourceName);
        if (resource == null) {
            throw new IOException("Resource [" + resourceName + "] not found in resource loader " + resourceLoader);
        }
        ChainReaderHelper helper = new ChainReaderHelper();
        helper.setBufferSize(262144);
        helper.setPrimaryReader((Reader)new BufferedReader(this.createReader(resource, encoding)));
        Vector<FilterChain> filterChains = new Vector<FilterChain>();
        filterChains.add(filterChain);
        helper.setFilterChains(filterChains);
        try (BufferedReader in = new BufferedReader(DefaultFileHandler.getAssembledReader((ChainReaderHelper)helper));
             BufferedWriter out = new BufferedWriter(new OutputStreamWriter(handler.getOutputStream(destFile)));){
            String line;
            while ((line = in.readLine()) != null) {
                if (line.isEmpty()) {
                    out.newLine();
                    continue;
                }
                out.write(line);
                out.newLine();
            }
        }
    }

    private InputStreamReader createReader(InputStream is, Charset encoding) throws UnsupportedEncodingException {
        InputStreamReader r = encoding != null ? new InputStreamReader(is, encoding) : new InputStreamReader(is);
        return r;
    }

    public File getResourceLocation(Class where, String resourceName) {
        URL url = where.getResource(resourceName);
        if (url == null) {
            throw new CargoException("Cannot find resource [" + resourceName + "]");
        }
        File file = null;
        String urlString = url.toString();
        if (urlString.startsWith("jar:file:")) {
            int pling = urlString.indexOf("!");
            String jar = urlString.substring(9, pling);
            try {
                file = new File(URLDecoder.decode(jar, StandardCharsets.UTF_8.name()));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("UTF-8 encoding is missing", e);
            }
        }
        if (urlString.startsWith("file:")) {
            int tail = urlString.indexOf(resourceName);
            String dir = urlString.substring(5, tail);
            try {
                file = new File(URLDecoder.decode(dir, StandardCharsets.UTF_8.name()));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("UTF-8 encoding is missing", e);
            }
        }
        this.getLogger().debug("Location for [" + resourceName + "] is [" + file + "]", ((Object)((Object)this)).getClass().getName());
        return file;
    }

    public String readResource(String resourceName, FilterChain filterChain, Charset encoding) throws IOException {
        String newLine = System.getProperty("line.separator");
        InputStream resource = resourceLoader.getResourceAsStream(resourceName);
        if (resource == null) {
            throw new CargoException("Resource [" + resourceName + "] not found in resource loader " + resourceLoader);
        }
        ChainReaderHelper helper = new ChainReaderHelper();
        helper.setBufferSize(8192);
        helper.setPrimaryReader((Reader)new BufferedReader(this.createReader(resource, encoding)));
        Vector<FilterChain> filterChains = new Vector<FilterChain>();
        filterChains.add(filterChain);
        helper.setFilterChains(filterChains);
        try (BufferedReader in = new BufferedReader(DefaultFileHandler.getAssembledReader((ChainReaderHelper)helper));){
            String line;
            StringBuilder out = new StringBuilder();
            while ((line = in.readLine()) != null) {
                if (line.isEmpty()) {
                    out.append(newLine);
                    continue;
                }
                if (out.length() > 0) {
                    out.append(newLine);
                }
                out.append(line);
            }
            String string = out.toString();
            return string;
        }
    }
}

