/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi.configuration;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.StandaloneLocalConfiguration;
import org.codehaus.cargo.container.property.LoggingLevel;
import org.codehaus.cargo.container.spi.configuration.AbstractLocalConfiguration;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.cargo.util.FileHandler;
import org.codehaus.cargo.util.XmlReplacement;

public abstract class AbstractStandaloneLocalConfiguration
extends AbstractLocalConfiguration
implements StandaloneLocalConfiguration {
    private Map<String, Map<FileHandler.XmlReplacementDetails, String>> xmlReplacements;

    public AbstractStandaloneLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.logging", LoggingLevel.MEDIUM.getLevel());
        this.xmlReplacements = new HashMap<String, Map<FileHandler.XmlReplacementDetails, String>>();
    }

    protected void performXmlReplacements(LocalContainer container) {
        boolean ignoreNonExistingProperties = Boolean.parseBoolean(this.getPropertyValue("cargo.standalone.ignoreNonExistingProperties"));
        for (Map.Entry<String, Map<FileHandler.XmlReplacementDetails, String>> xmlReplacementDetails : this.xmlReplacements.entrySet()) {
            HashSet<XmlReplacement> replacements = new HashSet<XmlReplacement>();
            String destinationFile = this.getFileHandler().append(container.getConfiguration().getHome(), xmlReplacementDetails.getKey());
            for (Map.Entry<FileHandler.XmlReplacementDetails, String> xmlReplacementDetail : xmlReplacementDetails.getValue().entrySet()) {
                String value = container.getConfiguration().getPropertyValue(xmlReplacementDetail.getValue());
                if (value == null) {
                    value = xmlReplacementDetail.getValue();
                }
                FileHandler.XmlReplacementDetails key = xmlReplacementDetail.getKey();
                XmlReplacement xmlReplacement = new XmlReplacement(destinationFile, key.getXpathExpression(), key.getAttributeName(), key.getReplacementBehavior(), value);
                if (ignoreNonExistingProperties) {
                    xmlReplacement.setReplacementBehavior(XmlReplacement.ReplacementBehavior.IGNORE_IF_NON_EXISTING);
                }
                replacements.add(xmlReplacement);
            }
            if (replacements.isEmpty()) continue;
            XmlReplacement[] replacementsArray = new XmlReplacement[replacements.size()];
            replacementsArray = replacements.toArray(replacementsArray);
            this.getFileHandler().replaceInXmlFile(replacementsArray);
        }
    }

    protected void setupConfigurationDir() throws IOException {
        String timestampFile = this.getFileHandler().append(this.getHome(), ".cargo");
        boolean isEmpty = false;
        if (!this.getFileHandler().exists(this.getHome())) {
            isEmpty = true;
        } else if (!this.getFileHandler().isDirectory(this.getHome())) {
            isEmpty = true;
        } else if (this.getFileHandler().isDirectoryEmpty(this.getHome())) {
            isEmpty = true;
        } else if (this.getFileHandler().exists(timestampFile)) {
            isEmpty = true;
        }
        if (!isEmpty) {
            throw new ContainerException("Invalid configuration dir [" + this.getHome() + "]. When using standalone configurations, the configuration dir must point to an empty directory - Except if the configuration was created by Cargo.");
        }
        this.getFileHandler().delete(this.getHome());
        this.getFileHandler().mkdirs(this.getHome());
        this.getFileHandler().createFile(timestampFile);
    }

    @Override
    public void addXmlReplacement(XmlReplacement xmlReplacement) {
        Map<FileHandler.XmlReplacementDetails, String> fileReplacements = this.xmlReplacements.get(xmlReplacement.getFile());
        if (fileReplacements == null) {
            fileReplacements = new HashMap<FileHandler.XmlReplacementDetails, String>();
            this.xmlReplacements.put(xmlReplacement.getFile(), fileReplacements);
        }
        fileReplacements.put(new FileHandler.XmlReplacementDetails(xmlReplacement.getXpathExpression(), xmlReplacement.getAttributeName(), xmlReplacement.getReplacementBehavior()), xmlReplacement.getValue());
    }

    @Override
    public void addXmlReplacement(String filename, String xpathExpression, String configurationPropertyName) {
        this.addXmlReplacement(filename, xpathExpression, null, configurationPropertyName);
    }

    @Override
    public void addXmlReplacement(String filename, String xpathExpression, String attributeName, String configurationPropertyName) {
        Map<FileHandler.XmlReplacementDetails, String> fileReplacements = this.xmlReplacements.get(filename);
        if (fileReplacements == null) {
            fileReplacements = new HashMap<FileHandler.XmlReplacementDetails, String>();
            this.xmlReplacements.put(filename, fileReplacements);
        }
        fileReplacements.put(new FileHandler.XmlReplacementDetails(xpathExpression, attributeName, XmlReplacement.ReplacementBehavior.THROW_EXCEPTION), configurationPropertyName);
    }

    @Override
    public void addXmlReplacement(String filename, String xpathExpression, String attributeName, String configurationPropertyName, XmlReplacement.ReplacementBehavior replacementBehavior) {
        Map<FileHandler.XmlReplacementDetails, String> fileReplacements = this.xmlReplacements.get(filename);
        if (fileReplacements == null) {
            fileReplacements = new HashMap<FileHandler.XmlReplacementDetails, String>();
            this.xmlReplacements.put(filename, fileReplacements);
        }
        fileReplacements.put(new FileHandler.XmlReplacementDetails(xpathExpression, attributeName, replacementBehavior), configurationPropertyName);
    }

    @Override
    public void removeXmlReplacement(String filename, String xpathExpression) {
        this.removeXmlReplacement(filename, xpathExpression, null);
    }

    @Override
    public void removeXmlReplacement(String filename, String xpathExpression, String attributeName) {
        Map<FileHandler.XmlReplacementDetails, String> fileReplacements = this.xmlReplacements.get(filename);
        if (fileReplacements != null) {
            fileReplacements.remove(new FileHandler.XmlReplacementDetails(xpathExpression, attributeName, XmlReplacement.ReplacementBehavior.THROW_EXCEPTION));
            if (fileReplacements.isEmpty()) {
                this.xmlReplacements.remove(filename);
            }
        }
    }

    @Override
    public List<XmlReplacement> getXmlReplacements() {
        ArrayList<XmlReplacement> xmlReplacements = new ArrayList<XmlReplacement>();
        for (Map.Entry<String, Map<FileHandler.XmlReplacementDetails, String>> xmlReplacementEntry : this.xmlReplacements.entrySet()) {
            for (Map.Entry<FileHandler.XmlReplacementDetails, String> xmlReplacementDetail : xmlReplacementEntry.getValue().entrySet()) {
                FileHandler.XmlReplacementDetails key = xmlReplacementDetail.getKey();
                XmlReplacement xmlReplacement = new XmlReplacement(xmlReplacementEntry.getKey(), key.getXpathExpression(), key.getAttributeName(), key.getReplacementBehavior(), xmlReplacementDetail.getValue());
                xmlReplacements.add(xmlReplacement);
            }
        }
        return xmlReplacements;
    }

    @Override
    public void verify() {
        super.verify();
        this.verifyLogging();
    }

    private void verifyLogging() {
        String level = this.getPropertyValue("cargo.logging");
        try {
            LoggingLevel.toLevel(level);
        }
        catch (IllegalArgumentException e) {
            throw new ContainerException("Invalid logging level [" + level + "]. Valid levels are {\"low\", \"medium\", \"high\"}");
        }
    }

    @Override
    public ConfigurationType getType() {
        return ConfigurationType.STANDALONE;
    }

    @Override
    protected void configureFiles(FilterChain filterChain, LocalContainer container) {
        this.performXmlReplacements(container);
        super.configureFiles(filterChain, container);
    }

    protected void replaceInFile(String file, Map<String, String> replacements, Charset encoding) throws CargoException {
        boolean ignoreNonExistingProperties = Boolean.parseBoolean(this.getPropertyValue("cargo.standalone.ignoreNonExistingProperties"));
        if (replacements.isEmpty()) {
            return;
        }
        String path = this.getHome() + "/" + file;
        this.getFileHandler().replaceInFile(path, replacements, encoding, ignoreNonExistingProperties);
    }
}

