/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.codehaus.cargo.module.Descriptor;
import org.codehaus.cargo.module.DescriptorIo;
import org.codehaus.cargo.module.DescriptorType;
import org.codehaus.cargo.module.J2eeDescriptor;
import org.codehaus.cargo.module.XmlEntityResolver;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.xml.sax.EntityResolver;

public abstract class AbstractDescriptorIo
implements DescriptorIo {
    private DescriptorType factory;

    protected AbstractDescriptorIo(DescriptorType descriptorType) {
        this.factory = descriptorType;
    }

    @Override
    public SAXBuilder createDocumentBuilder() {
        return this.createDocumentBuilder(null);
    }

    @Override
    public SAXBuilder createDocumentBuilder(EntityResolver theEntityResolver) {
        SAXBuilder factory = new SAXBuilder();
        factory.setValidation(false);
        factory.setFactory(this.factory.getJDOMFactory());
        EntityResolver resolver = theEntityResolver;
        if (resolver == null) {
            resolver = this.getEntityResolver();
        }
        if (resolver != null) {
            factory.setEntityResolver(resolver);
        }
        return factory;
    }

    protected EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public Document parseXml(InputStream input) throws JDOMException, IOException {
        return this.parseXml(input, new XmlEntityResolver());
    }

    @Override
    public Document parseXml(InputStream input, EntityResolver resolver) throws JDOMException, IOException {
        SAXBuilder builder = this.createDocumentBuilder(resolver);
        return builder.build(input);
    }

    public static void writeDescriptor(Descriptor descriptor, File file) throws IOException {
        AbstractDescriptorIo.writeDescriptor(descriptor, file, StandardCharsets.UTF_8, false);
    }

    public static void writeDescriptor(Descriptor descriptor, File file, Charset encoding) throws IOException {
        AbstractDescriptorIo.writeDescriptor(descriptor, file, encoding, false);
    }

    public static void writeDescriptor(Descriptor descriptor, File file, Charset encoding, boolean isIndent) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            AbstractDescriptorIo.writeDescriptor(descriptor, out, encoding, isIndent);
        }
    }

    public static void writeDescriptor(Descriptor descriptor, OutputStream out, Charset encoding, boolean isIndent) throws IOException {
        if (encoding == null) {
            throw new IllegalArgumentException("Encoding must not be null");
        }
        XMLOutputter serializer = new XMLOutputter();
        Format format = Format.getPrettyFormat();
        format.setEncoding(encoding.name());
        serializer.setFormat(format);
        StringWriter writer = new StringWriter();
        serializer.output((Document)descriptor, (Writer)writer);
        String result = writer.toString();
        String root = descriptor.getRootElement().getName();
        int startRoot = result.indexOf(root);
        int endRoot = result.indexOf(62, startRoot);
        String subString = result.substring(endRoot + 1);
        subString = subString.replaceAll(" xmlns=\".*\"", "");
        StringBuilder sb = new StringBuilder(result.substring(0, endRoot + 1));
        sb.append(subString);
        result = sb.toString();
        result = result.replace("<extension />", "");
        out.write(result.getBytes(encoding));
    }

    public static File[] writeAll(J2eeDescriptor descriptor, String dir) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        File webXmlFile = new File(dir, "web.xml");
        AbstractDescriptorIo.writeDescriptor((Descriptor)descriptor, webXmlFile, StandardCharsets.UTF_8, true);
        files.add(webXmlFile);
        for (Descriptor descr : descriptor.getVendorDescriptors()) {
            File file = new File(dir, descr.getFileName());
            AbstractDescriptorIo.writeDescriptor(descr, file, StandardCharsets.UTF_8, true);
            files.add(file);
        }
        return files.toArray(new File[files.size()]);
    }
}

