/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.application;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.codehaus.cargo.module.AbstractDescriptorIo;
import org.codehaus.cargo.module.application.ApplicationXml;
import org.codehaus.cargo.module.application.ApplicationXmlType;
import org.codehaus.cargo.module.application.ApplicationXmlVersion;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class ApplicationXmlIo
extends AbstractDescriptorIo {
    private ApplicationXmlIo() {
        super(ApplicationXmlType.getInstance());
    }

    public static ApplicationXml parseApplicationXmlFromFile(File file, EntityResolver entityResolver) throws IOException, JDOMException {
        try (FileInputStream in = new FileInputStream(file);){
            ApplicationXml applicationXml = ApplicationXmlIo.parseApplicationXml(in, entityResolver);
            return applicationXml;
        }
    }

    public static ApplicationXml parseApplicationXml(InputStream input, EntityResolver entityResolver) throws IOException, JDOMException {
        ApplicationXmlIo io = new ApplicationXmlIo();
        SAXBuilder builder = io.createDocumentBuilder();
        if (entityResolver != null) {
            builder.setEntityResolver(entityResolver);
        } else {
            builder.setEntityResolver((EntityResolver)new ApplicationXmlEntityResolver());
        }
        return (ApplicationXml)builder.build(input);
    }

    public static void writeApplicationXml(ApplicationXml appXml, File file) throws IOException {
        ApplicationXmlIo.writeApplicationXml(appXml, file, null, false);
    }

    public static void writeApplicationXml(ApplicationXml appXml, File file, Charset encoding) throws IOException {
        ApplicationXmlIo.writeApplicationXml(appXml, file, encoding, false);
    }

    public static void writeApplicationXml(ApplicationXml appXml, File file, Charset encoding, boolean isIndent) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            ApplicationXmlIo.writeApplicationXml(appXml, out, encoding, isIndent);
        }
    }

    public static void writeApplicationXml(ApplicationXml appXml, OutputStream output, Charset encoding, boolean isIndent) throws IOException {
        Format format = Format.getPrettyFormat();
        if (encoding != null) {
            format.setEncoding(encoding.name());
        }
        XMLOutputter serializer = new XMLOutputter(format);
        serializer.output(appXml.getDocument(), output);
    }

    private static class ApplicationXmlEntityResolver
    implements EntityResolver {
        private ApplicationXmlEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String thePublicId, String theSystemId) throws SAXException, IOException {
            ApplicationXmlVersion version = ApplicationXmlVersion.valueOf(thePublicId);
            if (version != null) {
                String fileName = version.getSystemId().substring(version.getSystemId().lastIndexOf(47));
                InputStream in = this.getClass().getResourceAsStream("/org/codehaus/cargo/module/internal/resource" + fileName);
                if (in != null) {
                    return new InputSource(in);
                }
            }
            return null;
        }
    }
}

