/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.webapp.jboss;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.codehaus.cargo.module.JarArchive;
import org.codehaus.cargo.module.JarArchiveIo;
import org.codehaus.cargo.module.webapp.jboss.JBossWebXml;
import org.codehaus.cargo.module.webapp.jboss.JBossWebXmlIo;
import org.jdom.JDOMException;

public class JBossWarArchive {
    private File warFile;
    private JBossWebXml jbossWebXml;

    public JBossWarArchive(File warFile) throws IOException, JDOMException {
        this.warFile = warFile;
        this.jbossWebXml = this.parseJBossWebXml();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JBossWebXml parseJBossWebXml() throws IOException, JDOMException {
        JBossWebXml webXml = null;
        try (InputStream in = null;){
            if (this.warFile.isDirectory()) {
                File contextXmlFile = new File(this.warFile, "WEB-INF/jboss-web.xml");
                if (contextXmlFile.exists()) {
                    in = new FileInputStream(contextXmlFile);
                }
            } else {
                JarArchive jarArchive = JarArchiveIo.open(this.warFile);
                in = jarArchive.getResource("WEB-INF/jboss-web.xml");
            }
            if (in != null) {
                webXml = JBossWebXmlIo.parseJBossWebXml(in);
            }
        }
        return webXml;
    }

    public JBossWebXml getJBossWebXml() {
        return this.jbossWebXml;
    }
}

