/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipFile;

public final class JarUtils {
    protected void createJarFromDirectory(File root, File directory, JarOutputStream jarStream) throws IOException {
        File[] filesToAdd;
        byte[] buffer = new byte[40960];
        for (File fileToAdd : filesToAdd = directory.listFiles()) {
            if (fileToAdd.isDirectory()) {
                this.createJarFromDirectory(root, fileToAdd, jarStream);
                continue;
            }
            try (FileInputStream addFile = new FileInputStream(fileToAdd);){
                int bytesRead;
                String entryName = fileToAdd.getPath().substring(root.getPath().length() + 1);
                entryName = entryName.replace('\\', '/');
                JarEntry entry = new JarEntry(entryName);
                jarStream.putNextEntry(entry);
                while ((bytesRead = addFile.read(buffer)) != -1) {
                    jarStream.write(buffer, 0, bytesRead);
                }
                jarStream.closeEntry();
            }
        }
    }

    public File createJarFromDirectory(String directory, File outputJar) throws IOException {
        if (!outputJar.getParentFile().exists()) {
            outputJar.getParentFile().mkdirs();
        }
        try (JarOutputStream jarStream = new JarOutputStream(new FileOutputStream(outputJar));){
            File dir = new File(directory);
            this.createJarFromDirectory(dir, dir, jarStream);
        }
        return outputJar;
    }

    public boolean containsClass(String jarFile, String classToBeFound) throws IOException {
        boolean result = false;
        ZipFile zip = new ZipFile(jarFile);
        String dataSourceClass = classToBeFound.replace('.', '/') + ".class";
        if (zip.getEntry(dataSourceClass) != null) {
            result = true;
        }
        zip.close();
        return result;
    }
}

