/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.truezip;

import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.truezip.AbstractArchiveMojo;
import org.codehaus.mojo.truezip.Fileset;
import org.codehaus.mojo.truezip.TrueZipFileSet;

public class CliListMojo
extends AbstractArchiveMojo {
    private File from;
    private boolean followSubArchive;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        this.intitializeArchiveDectector();
        Fileset fileset = new Fileset();
        fileset.setDirectory(this.from.getAbsolutePath());
        fileset.setFollowArchive(this.followSubArchive);
        List fileList = this.truezip.list((TrueZipFileSet)fileset);
        Iterator iter = fileList.iterator();
        while (iter.hasNext()) {
            TFile archiveFile = new TFile(((TFile)iter.next()).toString());
            String relativePath = archiveFile.getPath();
            if (relativePath.startsWith(this.from.getPath())) {
                relativePath = relativePath.substring(this.from.getPath().length() + 1);
            }
            long fileLen = archiveFile.length();
            System.out.println(fileLen + "\t" + new Date(archiveFile.lastModified()) + "\t" + relativePath);
        }
    }
}

