/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.util.Arrays;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.cipher.PseudoRandomFunction;
import org.eclipse.californium.scandium.util.ByteArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Finished
extends HandshakeMessage {
    private static final Logger LOG = LoggerFactory.getLogger((String)Finished.class.getName());
    private final byte[] verifyData;

    public Finished(byte[] masterSecret, boolean isClient, byte[] handshakeHash, InetSocketAddress peerAddress) {
        super(peerAddress);
        this.verifyData = this.getVerifyData(masterSecret, isClient, handshakeHash);
    }

    private Finished(byte[] verifyData, InetSocketAddress peerAddress) {
        super(peerAddress);
        this.verifyData = Arrays.copyOf(verifyData, verifyData.length);
    }

    public void verifyData(byte[] masterSecret, boolean isClient, byte[] handshakeHash) throws HandshakeException {
        byte[] myVerifyData = this.getVerifyData(masterSecret, isClient, handshakeHash);
        if (!Arrays.equals(myVerifyData, this.verifyData)) {
            StringBuilder msg = new StringBuilder("Verification of peer's [").append(this.getPeer()).append("] FINISHED message failed");
            if (LOG.isTraceEnabled()) {
                msg.append(System.lineSeparator()).append("Expected: ").append(ByteArrayUtils.toHexString(myVerifyData));
                msg.append(System.lineSeparator()).append("Received: ").append(ByteArrayUtils.toHexString(this.verifyData));
            }
            LOG.debug(msg.toString());
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, this.getPeer());
            throw new HandshakeException("Verification of FINISHED message failed", alert);
        }
    }

    private byte[] getVerifyData(byte[] masterSecret, boolean isClient, byte[] handshakeHash) {
        if (isClient) {
            return PseudoRandomFunction.doPRF(masterSecret, PseudoRandomFunction.Label.CLIENT_FINISHED_LABEL, handshakeHash);
        }
        return PseudoRandomFunction.doPRF(masterSecret, PseudoRandomFunction.Label.SERVER_FINISHED_LABEL, handshakeHash);
    }

    @Override
    public HandshakeType getMessageType() {
        return HandshakeType.FINISHED;
    }

    @Override
    public int getMessageLength() {
        return this.verifyData.length;
    }

    @Override
    public String toString() {
        return super.toString() + "\t\tVerify Data: " + ByteArrayUtils.toHexString(this.verifyData) + System.lineSeparator();
    }

    @Override
    public byte[] fragmentToByteArray() {
        DatagramWriter writer = new DatagramWriter();
        writer.writeBytes(this.verifyData);
        return writer.toByteArray();
    }

    public static HandshakeMessage fromByteArray(byte[] byteArray, InetSocketAddress peerAddress) {
        DatagramReader reader = new DatagramReader(byteArray);
        byte[] verifyData = reader.readBytesLeft();
        return new Finished(verifyData, peerAddress);
    }
}

