/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.util.Arrays;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.util.ByteArrayUtils;

public final class FragmentedHandshakeMessage
extends HandshakeMessage {
    private byte[] fragmentedBytes;
    private HandshakeType type;
    private int messageLength;

    public FragmentedHandshakeMessage(HandshakeType type, int messageLength, int messageSeq, int fragmentOffset, byte[] fragmentedBytes, InetSocketAddress peerAddress) {
        this(fragmentedBytes, type, fragmentOffset, messageLength, peerAddress);
        this.setMessageSeq(messageSeq);
    }

    public FragmentedHandshakeMessage(byte[] fragmentedBytes, HandshakeType type, int fragmentOffset, int messageLength, InetSocketAddress peerAddress) {
        super(peerAddress);
        this.type = type;
        this.messageLength = messageLength;
        this.fragmentedBytes = Arrays.copyOf(fragmentedBytes, fragmentedBytes.length);
        this.setFragmentOffset(fragmentOffset);
        this.setFragmentLength(fragmentedBytes.length);
    }

    @Override
    public HandshakeType getMessageType() {
        return this.type;
    }

    @Override
    public int getMessageLength() {
        return this.messageLength;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("\t\t\tFragmented Handshake Message: ").append(this.fragmentedBytes.length).append(" bytes").append(System.lineSeparator());
        sb.append("\t\t\t\t").append(ByteArrayUtils.toHexString(this.fragmentedBytes)).append(System.lineSeparator());
        return sb.toString();
    }

    @Override
    public byte[] fragmentToByteArray() {
        return this.fragmentedBytes;
    }
}

