/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.util;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class ServerName {
    private final NameType type;
    private final byte[] name;

    private ServerName(NameType type, byte[] name) {
        this.type = type;
        this.name = name;
    }

    public static ServerName from(NameType type, byte[] name) {
        if (type == null) {
            throw new NullPointerException("type must not be null");
        }
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        return new ServerName(type, name);
    }

    public static ServerName fromHostName(String hostName) {
        if (hostName == null) {
            throw new NullPointerException("host name must not be null");
        }
        return new ServerName(NameType.HOST_NAME, hostName.getBytes(StandardCharsets.US_ASCII));
    }

    public byte[] getName() {
        return this.name;
    }

    public NameType getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.name);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServerName other = (ServerName)obj;
        if (!Arrays.equals(this.name, other.name)) {
            return false;
        }
        return this.type == other.type;
    }

    public static enum NameType {
        HOST_NAME(0),
        UNDEFINED(-1);

        private byte code;

        private NameType(byte code) {
            this.code = code;
        }

        public byte getCode() {
            return this.code;
        }

        public static NameType fromCode(byte code) {
            for (NameType type : NameType.values()) {
                if (type.code != code) continue;
                return type;
            }
            return UNDEFINED;
        }
    }
}

