/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.server;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.HTTP2Connection;
import org.eclipse.jetty.http2.ISession;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.api.server.ServerSessionListener;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.Frame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PrefaceFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.http2.frames.SettingsFrame;
import org.eclipse.jetty.http2.parser.ServerParser;
import org.eclipse.jetty.http2.parser.SettingsBodyParser;
import org.eclipse.jetty.http2.server.HttpChannelOverHTTP2;
import org.eclipse.jetty.http2.server.HttpTransportOverHTTP2;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.util.B64Code;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.TypeUtil;

public class HTTP2ServerConnection
extends HTTP2Connection
implements Connection.UpgradeTo {
    private final Queue<HttpChannelOverHTTP2> channels = new ArrayDeque<HttpChannelOverHTTP2>();
    private final List<Frame> upgradeFrames = new ArrayList<Frame>();
    private final AtomicLong totalRequests = new AtomicLong();
    private final AtomicLong totalResponses = new AtomicLong();
    private final ServerSessionListener listener;
    private final HttpConfiguration httpConfig;

    public static boolean isSupportedProtocol(String protocol) {
        switch (protocol) {
            case "h2": 
            case "h2-17": 
            case "h2-16": 
            case "h2-15": 
            case "h2-14": 
            case "h2c": 
            case "h2c-17": 
            case "h2c-16": 
            case "h2c-15": 
            case "h2c-14": {
                return true;
            }
        }
        return false;
    }

    public HTTP2ServerConnection(ByteBufferPool byteBufferPool, Executor executor, EndPoint endPoint, HttpConfiguration httpConfig, ServerParser parser, ISession session, int inputBufferSize, ServerSessionListener listener) {
        super(byteBufferPool, executor, endPoint, parser, session, inputBufferSize);
        this.listener = listener;
        this.httpConfig = httpConfig;
    }

    @Override
    public long getMessagesIn() {
        return this.totalRequests.get();
    }

    @Override
    public long getMessagesOut() {
        return this.totalResponses.get();
    }

    @Override
    protected ServerParser getParser() {
        return (ServerParser)super.getParser();
    }

    @Override
    public void onUpgradeTo(ByteBuffer buffer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 onUpgradeTo {} {}", this, BufferUtil.toDetailString(buffer));
        }
        this.setInputBuffer(buffer);
    }

    @Override
    public void onOpen() {
        this.notifyAccept(this.getSession());
        for (Frame frame : this.upgradeFrames) {
            this.getSession().onFrame(frame);
        }
        super.onOpen();
    }

    private void notifyAccept(ISession session) {
        try {
            this.listener.onAccept(session);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener " + this.listener, x);
        }
    }

    public void onNewStream(Connector connector, IStream stream, HeadersFrame frame) {
        HttpChannelOverHTTP2 channel;
        Runnable task;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing {} on {}", frame, stream);
        }
        if ((task = (channel = this.provideHttpChannel(connector, stream)).onRequest(frame)) != null) {
            this.offerTask(task, false);
        }
    }

    public void onData(IStream stream, DataFrame frame, Callback callback) {
        Runnable task;
        HttpChannelOverHTTP2 channel;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing {} on {}", frame, stream);
        }
        if ((channel = (HttpChannelOverHTTP2)stream.getAttribute(IStream.CHANNEL_ATTRIBUTE)) != null && (task = channel.onRequestContent(frame, callback)) != null) {
            this.offerTask(task, false);
        }
    }

    public void onTrailers(IStream stream, HeadersFrame frame) {
        HttpChannelOverHTTP2 channel;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing trailers {} on {}", frame, stream);
        }
        if ((channel = (HttpChannelOverHTTP2)stream.getAttribute(IStream.CHANNEL_ATTRIBUTE)) != null) {
            channel.onRequestTrailers(frame);
        }
    }

    public boolean onStreamTimeout(IStream stream, Throwable failure) {
        boolean result;
        HttpChannelOverHTTP2 channel = (HttpChannelOverHTTP2)stream.getAttribute(IStream.CHANNEL_ATTRIBUTE);
        boolean bl = result = channel != null && channel.onStreamTimeout(failure);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} idle timeout on {}: {}", result ? "Processed" : "Ignored", stream, failure);
        }
        return result;
    }

    public void onStreamFailure(IStream stream, Throwable failure) {
        HttpChannelOverHTTP2 channel;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing failure on {}: {}", stream, failure);
        }
        if ((channel = (HttpChannelOverHTTP2)stream.getAttribute(IStream.CHANNEL_ATTRIBUTE)) != null) {
            channel.onFailure(failure);
        }
    }

    public boolean onSessionTimeout(Throwable failure) {
        ISession session = this.getSession();
        boolean result = true;
        for (Stream stream : session.getStreams()) {
            HttpChannelOverHTTP2 channel = (HttpChannelOverHTTP2)stream.getAttribute(IStream.CHANNEL_ATTRIBUTE);
            if (channel == null) continue;
            result &= !channel.isRequestHandled();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} idle timeout on {}: {}", result ? "Processed" : "Ignored", session, failure);
        }
        return result;
    }

    public void onSessionFailure(Throwable failure) {
        ISession session = this.getSession();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing failure on {}: {}", session, failure);
        }
        for (Stream stream : session.getStreams()) {
            this.onStreamFailure((IStream)stream, failure);
        }
    }

    public void push(Connector connector, IStream stream, MetaData.Request request) {
        HttpChannelOverHTTP2 channel;
        Runnable task;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing push {} on {}", request, stream);
        }
        if ((task = (channel = this.provideHttpChannel(connector, stream)).onPushRequest(request)) != null) {
            this.offerTask(task, true);
        }
    }

    private HttpChannelOverHTTP2 provideHttpChannel(Connector connector, IStream stream) {
        HttpChannelOverHTTP2 channel = this.pollChannel();
        if (channel != null) {
            channel.getHttpTransport().setStream(stream);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Recycling channel {} for {}", channel, this);
            }
        } else {
            HttpTransportOverHTTP2 transport = new HttpTransportOverHTTP2(connector, this);
            transport.setStream(stream);
            channel = new ServerHttpChannelOverHTTP2(connector, this.httpConfig, this.getEndPoint(), transport);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating channel {} for {}", channel, this);
            }
        }
        stream.setAttribute(IStream.CHANNEL_ATTRIBUTE, channel);
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void offerChannel(HttpChannelOverHTTP2 channel) {
        HTTP2ServerConnection hTTP2ServerConnection = this;
        synchronized (hTTP2ServerConnection) {
            this.channels.offer(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpChannelOverHTTP2 pollChannel() {
        HTTP2ServerConnection hTTP2ServerConnection = this;
        synchronized (hTTP2ServerConnection) {
            return this.channels.poll();
        }
    }

    public boolean upgrade(MetaData.Request request) {
        if (HttpMethod.PRI.is(request.getMethod())) {
            this.getParser().directUpgrade();
        } else {
            SettingsFrame settingsFrame;
            HttpField settingsField = request.getFields().getField(HttpHeader.HTTP2_SETTINGS);
            if (settingsField == null) {
                throw new BadMessageException("Missing " + (Object)((Object)HttpHeader.HTTP2_SETTINGS) + " header");
            }
            String value = settingsField.getValue();
            byte[] settings = B64Code.decodeRFC4648URL(value == null ? "" : value);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} settings {}", this, TypeUtil.toHexString(settings));
            }
            if ((settingsFrame = SettingsBodyParser.parseBody(BufferUtil.toBuffer(settings))) == null) {
                LOG.warn("Invalid {} header value: {}", new Object[]{HttpHeader.HTTP2_SETTINGS, value});
                throw new BadMessageException();
            }
            this.getParser().standardUpgrade();
            this.upgradeFrames.add(new PrefaceFrame());
            this.upgradeFrames.add(settingsFrame);
            this.upgradeFrames.add(new HeadersFrame(1, new MetaData.Request(request), null, true));
        }
        return true;
    }

    private class ServerHttpChannelOverHTTP2
    extends HttpChannelOverHTTP2
    implements Closeable {
        public ServerHttpChannelOverHTTP2(Connector connector, HttpConfiguration configuration, EndPoint endPoint, HttpTransportOverHTTP2 transport) {
            super(connector, configuration, endPoint, transport);
        }

        @Override
        public Runnable onRequest(HeadersFrame frame) {
            HTTP2ServerConnection.this.totalRequests.incrementAndGet();
            return super.onRequest(frame);
        }

        @Override
        public void onCompleted() {
            HTTP2ServerConnection.this.totalResponses.incrementAndGet();
            super.onCompleted();
            if (!this.getStream().isReset()) {
                this.recycle();
            }
        }

        @Override
        public void recycle() {
            this.getStream().removeAttribute(IStream.CHANNEL_ATTRIBUTE);
            super.recycle();
            HTTP2ServerConnection.this.offerChannel(this);
        }

        @Override
        public void close() {
            IStream stream = this.getStream();
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP2 Request #{}/{} rejected", stream.getId(), Integer.toHexString(stream.getSession().hashCode()));
            }
            stream.reset(new ResetFrame(stream.getId(), ErrorCode.ENHANCE_YOUR_CALM_ERROR.code), Callback.NOOP);
            this.consumeInput();
        }
    }
}

