/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.jdbc;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import org.elasticsearch.xpack.sql.jdbc.JdbcPreparedStatement;
import org.elasticsearch.xpack.sql.jdbc.JdbcWrapper;
import org.elasticsearch.xpack.sql.jdbc.PreparedQuery;
import org.elasticsearch.xpack.sql.jdbc.TypeUtils;

class JdbcParameterMetaData
implements ParameterMetaData,
JdbcWrapper {
    private final JdbcPreparedStatement ps;

    JdbcParameterMetaData(JdbcPreparedStatement ps) {
        this.ps = ps;
    }

    @Override
    public int getParameterCount() throws SQLException {
        this.ps.checkOpen();
        return this.ps.query.paramCount();
    }

    @Override
    public int isNullable(int param) throws SQLException {
        this.ps.checkOpen();
        return 2;
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        return TypeUtils.isSigned(this.paramInfo((int)param).type);
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        this.ps.checkOpen();
        return 0;
    }

    @Override
    public int getScale(int param) throws SQLException {
        this.ps.checkOpen();
        return 0;
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        return this.paramInfo((int)param).type.getVendorTypeNumber();
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        return this.paramInfo((int)param).type.getName();
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        return TypeUtils.classOf(this.paramInfo((int)param).type).getName();
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        this.ps.checkOpen();
        return 0;
    }

    private PreparedQuery.ParamInfo paramInfo(int param) throws SQLException {
        this.ps.checkOpen();
        return this.ps.query.getParam(param);
    }
}

