/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.jdbc;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Locale;
import java.util.function.Function;
import org.elasticsearch.xpack.sql.jdbc.EsType;
import org.elasticsearch.xpack.sql.jdbc.JdbcDateUtils;
import org.elasticsearch.xpack.sql.jdbc.TypeUtils;
import shadow.org.elasticsearch.geometry.utils.StandardValidator;
import shadow.org.elasticsearch.geometry.utils.WellKnownText;
import shadow.org.elasticsearch.xpack.sql.proto.StringUtils;

final class TypeConverter {
    private TypeConverter() {
    }

    static Date convertDate(Long millis, Calendar cal) {
        return TypeConverter.dateTimeConvert(millis, cal, c -> {
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
            return new Date(c.getTimeInMillis());
        });
    }

    static Time convertTime(Long millis, Calendar cal) {
        return TypeConverter.dateTimeConvert(millis, cal, c -> {
            c.set(0, 1);
            c.set(1, 1970);
            c.set(2, 0);
            c.set(5, 1);
            return new Time(c.getTimeInMillis());
        });
    }

    static Timestamp convertTimestamp(Long millis, int nanos, Calendar cal) {
        Timestamp ts = TypeConverter.dateTimeConvert(millis, cal, c -> new Timestamp(c.getTimeInMillis()));
        if (ts != null) {
            ts.setNanos(nanos);
        }
        return ts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T dateTimeConvert(Long millis, Calendar c, Function<Calendar, T> creator) {
        if (millis == null) {
            return null;
        }
        long initial = c.getTimeInMillis();
        try {
            c.setTimeInMillis(millis);
            T t = creator.apply(c);
            return t;
        }
        finally {
            c.setTimeInMillis(initial);
        }
    }

    static long convertFromCalendarToUTC(long value, Calendar cal) {
        if (cal == null) {
            return value;
        }
        Calendar c = (Calendar)cal.clone();
        c.setTimeInMillis(value);
        ZonedDateTime convertedDateTime = ZonedDateTime.ofInstant(c.toInstant(), c.getTimeZone().toZoneId()).withZoneSameLocal(ZoneOffset.UTC);
        return convertedDateTime.toInstant().toEpochMilli();
    }

    static <T> T convert(Object val, EsType columnType, Class<T> type, String typeString) throws SQLException {
        if (type == null) {
            return (T)TypeConverter.convert(val, columnType, typeString);
        }
        if (type.isInstance(val) && TypeUtils.classOf(columnType) == type) {
            try {
                return type.cast(val);
            }
            catch (ClassCastException cce) {
                TypeConverter.failConversion(val, columnType, typeString, type, cce);
            }
        }
        if (type == String.class) {
            return (T)TypeConverter.asString(TypeConverter.convert(val, columnType, typeString));
        }
        if (type == Boolean.class) {
            return (T)TypeConverter.asBoolean(val, columnType, typeString);
        }
        if (type == Byte.class) {
            return (T)TypeConverter.asByte(val, columnType, typeString);
        }
        if (type == Short.class) {
            return (T)TypeConverter.asShort(val, columnType, typeString);
        }
        if (type == Integer.class) {
            return (T)TypeConverter.asInteger(val, columnType, typeString);
        }
        if (type == Long.class) {
            return (T)TypeConverter.asLong(val, columnType, typeString);
        }
        if (type == Float.class) {
            return (T)TypeConverter.asFloat(val, columnType, typeString);
        }
        if (type == Double.class) {
            return (T)TypeConverter.asDouble(val, columnType, typeString);
        }
        if (type == Date.class) {
            return (T)TypeConverter.asDate(val, columnType, typeString);
        }
        if (type == Time.class) {
            return (T)TypeConverter.asTime(val, columnType, typeString);
        }
        if (type == Timestamp.class) {
            return (T)TypeConverter.asTimestamp(val, columnType, typeString);
        }
        if (type == byte[].class) {
            return (T)TypeConverter.asByteArray(val, columnType, typeString);
        }
        if (type == BigDecimal.class) {
            return (T)TypeConverter.asBigDecimal(val, columnType, typeString);
        }
        if (type == LocalDate.class) {
            return (T)TypeConverter.asLocalDate(val, columnType, typeString);
        }
        if (type == LocalTime.class) {
            return (T)TypeConverter.asLocalTime(val, columnType, typeString);
        }
        if (type == LocalDateTime.class) {
            return (T)TypeConverter.asLocalDateTime(val, columnType, typeString);
        }
        if (type == OffsetTime.class) {
            return (T)TypeConverter.asOffsetTime(val, columnType, typeString);
        }
        if (type == OffsetDateTime.class) {
            return (T)TypeConverter.asOffsetDateTime(val, columnType, typeString);
        }
        return TypeConverter.failConversion(val, columnType, typeString, type);
    }

    static Object convert(Object v, EsType columnType, String typeString) throws SQLException {
        switch (columnType) {
            case NULL: {
                return null;
            }
            case BOOLEAN: 
            case TEXT: 
            case KEYWORD: {
                return v;
            }
            case BYTE: {
                return ((Number)v).byteValue();
            }
            case SHORT: {
                return ((Number)v).shortValue();
            }
            case INTEGER: {
                return ((Number)v).intValue();
            }
            case LONG: {
                return ((Number)v).longValue();
            }
            case HALF_FLOAT: 
            case SCALED_FLOAT: 
            case DOUBLE: {
                return TypeConverter.doubleValue(v);
            }
            case FLOAT: {
                return TypeConverter.floatValue(v);
            }
            case DATE: {
                return JdbcDateUtils.asDateTimeField(v, JdbcDateUtils::asDate, Date::new);
            }
            case TIME: {
                return JdbcDateUtils.timeAsTime(v.toString());
            }
            case DATETIME: {
                return JdbcDateUtils.asDateTimeField(v, JdbcDateUtils::asTimestamp, Timestamp::new);
            }
            case INTERVAL_YEAR: 
            case INTERVAL_MONTH: 
            case INTERVAL_YEAR_TO_MONTH: {
                return Period.parse(v.toString());
            }
            case INTERVAL_DAY: 
            case INTERVAL_HOUR: 
            case INTERVAL_MINUTE: 
            case INTERVAL_SECOND: 
            case INTERVAL_DAY_TO_HOUR: 
            case INTERVAL_DAY_TO_MINUTE: 
            case INTERVAL_DAY_TO_SECOND: 
            case INTERVAL_HOUR_TO_MINUTE: 
            case INTERVAL_HOUR_TO_SECOND: 
            case INTERVAL_MINUTE_TO_SECOND: {
                return Duration.parse(v.toString());
            }
            case GEO_POINT: 
            case GEO_SHAPE: 
            case SHAPE: {
                try {
                    return WellKnownText.fromWKT(StandardValidator.instance(true), true, v.toString());
                }
                catch (IOException | ParseException ex) {
                    throw new SQLException("Cannot parse geo_shape", ex);
                }
            }
            case IP: {
                return v.toString();
            }
        }
        throw new SQLException("Unexpected column type [" + typeString + "]");
    }

    private static Double doubleValue(Object v) {
        if (v instanceof String) {
            switch ((String)v) {
                case "NaN": {
                    return Double.NaN;
                }
                case "Infinity": {
                    return Double.POSITIVE_INFINITY;
                }
                case "-Infinity": {
                    return Double.NEGATIVE_INFINITY;
                }
            }
            return Double.parseDouble((String)v);
        }
        return ((Number)v).doubleValue();
    }

    private static Float floatValue(Object v) {
        if (v instanceof String) {
            switch ((String)v) {
                case "NaN": {
                    return Float.valueOf(Float.NaN);
                }
                case "Infinity": {
                    return Float.valueOf(Float.POSITIVE_INFINITY);
                }
                case "-Infinity": {
                    return Float.valueOf(Float.NEGATIVE_INFINITY);
                }
            }
            return Float.valueOf(Float.parseFloat((String)v));
        }
        return Float.valueOf(((Number)v).floatValue());
    }

    private static String asString(Object nativeValue) {
        return nativeValue == null ? null : StringUtils.toString(nativeValue);
    }

    private static <T> T failConversion(Object value, EsType columnType, String typeString, Class<T> target) throws SQLException {
        return TypeConverter.failConversion(value, columnType, typeString, target, null);
    }

    private static <T> T failConversion(Object value, EsType columnType, String typeString, Class<T> target, Exception e) throws SQLException {
        String message = String.format(Locale.ROOT, "Unable to convert value [%.128s] of type [%s] to [%s]", value, columnType, typeString);
        throw e != null ? new SQLException(message, e) : new SQLException(message);
    }

    private static Boolean asBoolean(Object val, EsType columnType, String typeString) throws SQLException {
        switch (columnType) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INTEGER: 
            case LONG: 
            case HALF_FLOAT: 
            case SCALED_FLOAT: 
            case DOUBLE: 
            case FLOAT: {
                return Integer.signum(((Number)val).intValue()) != 0;
            }
            case TEXT: 
            case KEYWORD: {
                return Boolean.valueOf((String)val);
            }
        }
        return TypeConverter.failConversion(val, columnType, typeString, Boolean.class);
    }

    private static Byte asByte(Object val, EsType columnType, String typeString) throws SQLException {
        switch (columnType) {
            case BOOLEAN: {
                return (Boolean)val != false ? (byte)1 : 0;
            }
            case BYTE: 
            case SHORT: 
            case INTEGER: 
            case LONG: {
                return TypeConverter.safeToByte(((Number)val).longValue());
            }
            case HALF_FLOAT: 
            case SCALED_FLOAT: 
            case DOUBLE: 
            case FLOAT: {
                return TypeConverter.safeToByte(TypeConverter.safeToLong(((Number)val).doubleValue()));
            }
            case TEXT: 
            case KEYWORD: {
                try {
                    return Byte.valueOf((String)val);
                }
                catch (NumberFormatException e) {
                    return TypeConverter.failConversion(val, columnType, typeString, Byte.class, e);
                }
            }
        }
        return TypeConverter.failConversion(val, columnType, typeString, Byte.class);
    }

    private static Short asShort(Object val, EsType columnType, String typeString) throws SQLException {
        switch (columnType) {
            case BOOLEAN: {
                return (Boolean)val != false ? (short)1 : 0;
            }
            case BYTE: 
            case SHORT: 
            case INTEGER: 
            case LONG: {
                return TypeConverter.safeToShort(((Number)val).longValue());
            }
            case HALF_FLOAT: 
            case SCALED_FLOAT: 
            case DOUBLE: 
            case FLOAT: {
                return TypeConverter.safeToShort(TypeConverter.safeToLong(((Number)val).doubleValue()));
            }
            case TEXT: 
            case KEYWORD: {
                try {
                    return Short.valueOf((String)val);
                }
                catch (NumberFormatException e) {
                    return TypeConverter.failConversion(val, columnType, typeString, Short.class, e);
                }
            }
        }
        return TypeConverter.failConversion(val, columnType, typeString, Short.class);
    }

    private static Integer asInteger(Object val, EsType columnType, String typeString) throws SQLException {
        switch (columnType) {
            case BOOLEAN: {
                return (Boolean)val != false ? 1 : 0;
            }
            case BYTE: 
            case SHORT: 
            case INTEGER: 
            case LONG: {
                return TypeConverter.safeToInt(((Number)val).longValue());
            }
            case HALF_FLOAT: 
            case SCALED_FLOAT: 
            case DOUBLE: 
            case FLOAT: {
                return TypeConverter.safeToInt(TypeConverter.safeToLong(((Number)val).doubleValue()));
            }
            case TEXT: 
            case KEYWORD: {
                try {
                    return Integer.valueOf((String)val);
                }
                catch (NumberFormatException e) {
                    return TypeConverter.failConversion(val, columnType, typeString, Integer.class, e);
                }
            }
        }
        return TypeConverter.failConversion(val, columnType, typeString, Integer.class);
    }

    private static Long asLong(Object val, EsType columnType, String typeString) throws SQLException {
        switch (columnType) {
            case BOOLEAN: {
                return (Boolean)val != false ? 1L : 0L;
            }
            case BYTE: 
            case SHORT: 
            case INTEGER: 
            case LONG: {
                return ((Number)val).longValue();
            }
            case HALF_FLOAT: 
            case SCALED_FLOAT: 
            case DOUBLE: 
            case FLOAT: {
                return TypeConverter.safeToLong(((Number)val).doubleValue());
            }
            case TEXT: 
            case KEYWORD: {
                try {
                    return Long.valueOf((String)val);
                }
                catch (NumberFormatException e) {
                    return TypeConverter.failConversion(val, columnType, typeString, Long.class, e);
                }
            }
        }
        return TypeConverter.failConversion(val, columnType, typeString, Long.class);
    }

    private static Float asFloat(Object val, EsType columnType, String typeString) throws SQLException {
        switch (columnType) {
            case BOOLEAN: {
                return Float.valueOf((Boolean)val != false ? 1.0f : 0.0f);
            }
            case BYTE: 
            case SHORT: 
            case INTEGER: 
            case LONG: {
                return Float.valueOf(((Number)val).longValue());
            }
            case HALF_FLOAT: 
            case SCALED_FLOAT: 
            case DOUBLE: 
            case FLOAT: {
                return Float.valueOf(((Number)val).floatValue());
            }
            case TEXT: 
            case KEYWORD: {
                try {
                    return Float.valueOf((String)val);
                }
                catch (NumberFormatException e) {
                    return TypeConverter.failConversion(val, columnType, typeString, Float.class, e);
                }
            }
        }
        return TypeConverter.failConversion(val, columnType, typeString, Float.class);
    }

    private static Double asDouble(Object val, EsType columnType, String typeString) throws SQLException {
        switch (columnType) {
            case BOOLEAN: {
                return (Boolean)val != false ? 1.0 : 0.0;
            }
            case BYTE: 
            case SHORT: 
            case INTEGER: 
            case LONG: {
                return ((Number)val).longValue();
            }
            case HALF_FLOAT: 
            case SCALED_FLOAT: 
            case DOUBLE: 
            case FLOAT: {
                return ((Number)val).doubleValue();
            }
            case TEXT: 
            case KEYWORD: {
                try {
                    return Double.valueOf((String)val);
                }
                catch (NumberFormatException e) {
                    return TypeConverter.failConversion(val, columnType, typeString, Double.class, e);
                }
            }
        }
        return TypeConverter.failConversion(val, columnType, typeString, Double.class);
    }

    private static Date asDate(Object val, EsType columnType, String typeString) throws SQLException {
        if (columnType == EsType.DATETIME || columnType == EsType.DATE) {
            return JdbcDateUtils.asDateTimeField(val, JdbcDateUtils::asDate, Date::new);
        }
        if (columnType == EsType.TIME) {
            return new Date(0L);
        }
        return TypeConverter.failConversion(val, columnType, typeString, Date.class);
    }

    private static Time asTime(Object val, EsType columnType, String typeString) throws SQLException {
        if (columnType == EsType.DATETIME) {
            return JdbcDateUtils.asDateTimeField(val, JdbcDateUtils::asTime, Time::new);
        }
        if (columnType == EsType.TIME) {
            return JdbcDateUtils.asDateTimeField(val, JdbcDateUtils::timeAsTime, Time::new);
        }
        if (columnType == EsType.DATE) {
            return new Time(0L);
        }
        return TypeConverter.failConversion(val, columnType, typeString, Time.class);
    }

    private static Timestamp asTimestamp(Object val, EsType columnType, String typeString) throws SQLException {
        if (columnType == EsType.DATETIME || columnType == EsType.DATE) {
            return JdbcDateUtils.asDateTimeField(val, JdbcDateUtils::asTimestamp, Timestamp::new);
        }
        if (columnType == EsType.TIME) {
            return JdbcDateUtils.asDateTimeField(val, JdbcDateUtils::timeAsTimestamp, Timestamp::new);
        }
        return TypeConverter.failConversion(val, columnType, typeString, Timestamp.class);
    }

    private static byte[] asByteArray(Object val, EsType columnType, String typeString) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    private static BigDecimal asBigDecimal(Object val, EsType columnType, String typeString) throws SQLException {
        switch (columnType) {
            case BOOLEAN: {
                return (Boolean)val != false ? BigDecimal.ONE : BigDecimal.ZERO;
            }
            case BYTE: 
            case SHORT: 
            case INTEGER: 
            case LONG: {
                return BigDecimal.valueOf(((Number)val).longValue());
            }
            case HALF_FLOAT: 
            case FLOAT: {
                return new BigDecimal(String.valueOf(((Number)val).floatValue()));
            }
            case SCALED_FLOAT: 
            case DOUBLE: {
                return BigDecimal.valueOf(((Number)val).doubleValue());
            }
            case TEXT: 
            case KEYWORD: {
                try {
                    return new BigDecimal((String)val);
                }
                catch (NumberFormatException nfe) {
                    return TypeConverter.failConversion(val, columnType, typeString, BigDecimal.class, nfe);
                }
            }
        }
        return TypeConverter.failConversion(val, columnType, typeString, BigDecimal.class);
    }

    private static LocalDate asLocalDate(Object val, EsType columnType, String typeString) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    private static LocalTime asLocalTime(Object val, EsType columnType, String typeString) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    private static LocalDateTime asLocalDateTime(Object val, EsType columnType, String typeString) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    private static OffsetTime asOffsetTime(Object val, EsType columnType, String typeString) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    private static OffsetDateTime asOffsetDateTime(Object val, EsType columnType, String typeString) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    private static byte safeToByte(long x) throws SQLException {
        if (x > 127L || x < -128L) {
            throw new SQLException(String.format(Locale.ROOT, "Numeric %s out of range", Long.toString(x)));
        }
        return (byte)x;
    }

    private static short safeToShort(long x) throws SQLException {
        if (x > 32767L || x < -32768L) {
            throw new SQLException(String.format(Locale.ROOT, "Numeric %s out of range", Long.toString(x)));
        }
        return (short)x;
    }

    private static int safeToInt(long x) throws SQLException {
        if (x > Integer.MAX_VALUE || x < Integer.MIN_VALUE) {
            throw new SQLException(String.format(Locale.ROOT, "Numeric %s out of range", Long.toString(x)));
        }
        return (int)x;
    }

    private static long safeToLong(double x) throws SQLException {
        if (x > 9.223372036854776E18 || x < -9.223372036854776E18) {
            throw new SQLException(String.format(Locale.ROOT, "Numeric %s out of range", Double.toString(x)));
        }
        return Math.round(x);
    }
}

