/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.elasticsearch.geometry.utils;

import shadow.org.elasticsearch.geometry.Circle;
import shadow.org.elasticsearch.geometry.Geometry;
import shadow.org.elasticsearch.geometry.GeometryCollection;
import shadow.org.elasticsearch.geometry.GeometryVisitor;
import shadow.org.elasticsearch.geometry.Line;
import shadow.org.elasticsearch.geometry.LinearRing;
import shadow.org.elasticsearch.geometry.MultiLine;
import shadow.org.elasticsearch.geometry.MultiPoint;
import shadow.org.elasticsearch.geometry.MultiPolygon;
import shadow.org.elasticsearch.geometry.Point;
import shadow.org.elasticsearch.geometry.Polygon;
import shadow.org.elasticsearch.geometry.Rectangle;
import shadow.org.elasticsearch.geometry.utils.GeometryValidator;

public class StandardValidator
implements GeometryValidator {
    private static final GeometryValidator TRUE = new StandardValidator(true);
    private static final GeometryValidator FALSE = new StandardValidator(false);
    private final boolean ignoreZValue;

    private StandardValidator(boolean ignoreZValue) {
        this.ignoreZValue = ignoreZValue;
    }

    public static GeometryValidator instance(boolean ignoreZValue) {
        return ignoreZValue ? TRUE : FALSE;
    }

    protected void checkZ(double zValue) {
        if (!this.ignoreZValue && !Double.isNaN(zValue)) {
            throw new IllegalArgumentException("found Z value [" + zValue + "] but [ignore_z_value] parameter is [" + this.ignoreZValue + "]");
        }
    }

    @Override
    public void validate(Geometry geometry) {
        if (!this.ignoreZValue) {
            geometry.visit(new GeometryVisitor<Void, RuntimeException>(){

                @Override
                public Void visit(Circle circle) throws RuntimeException {
                    StandardValidator.this.checkZ(circle.getZ());
                    return null;
                }

                @Override
                public Void visit(GeometryCollection<?> collection) throws RuntimeException {
                    for (Geometry g : collection) {
                        g.visit(this);
                    }
                    return null;
                }

                @Override
                public Void visit(Line line) throws RuntimeException {
                    for (int i = 0; i < line.length(); ++i) {
                        StandardValidator.this.checkZ(line.getZ(i));
                    }
                    return null;
                }

                @Override
                public Void visit(LinearRing ring) throws RuntimeException {
                    for (int i = 0; i < ring.length(); ++i) {
                        StandardValidator.this.checkZ(ring.getZ(i));
                    }
                    return null;
                }

                @Override
                public Void visit(MultiLine multiLine) throws RuntimeException {
                    return this.visit((GeometryCollection)multiLine);
                }

                @Override
                public Void visit(MultiPoint multiPoint) throws RuntimeException {
                    return this.visit((GeometryCollection)multiPoint);
                }

                @Override
                public Void visit(MultiPolygon multiPolygon) throws RuntimeException {
                    return this.visit((GeometryCollection)multiPolygon);
                }

                @Override
                public Void visit(Point point) throws RuntimeException {
                    StandardValidator.this.checkZ(point.getZ());
                    return null;
                }

                @Override
                public Void visit(Polygon polygon) throws RuntimeException {
                    polygon.getPolygon().visit(this);
                    for (int i = 0; i < polygon.getNumberOfHoles(); ++i) {
                        polygon.getHole(i).visit(this);
                    }
                    return null;
                }

                @Override
                public Void visit(Rectangle rectangle) throws RuntimeException {
                    StandardValidator.this.checkZ(rectangle.getMinZ());
                    StandardValidator.this.checkZ(rectangle.getMaxZ());
                    return null;
                }
            });
        }
    }
}

