/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo.builders;

import com.vividsolutions.jts.geom.Coordinate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.xcontent.XContentBuilder;

public abstract class PointCollection<E extends PointCollection<E>>
extends ShapeBuilder {
    protected final ArrayList<Coordinate> points;
    protected boolean translated = false;

    protected PointCollection() {
        this(new ArrayList<Coordinate>());
    }

    protected PointCollection(ArrayList<Coordinate> points) {
        this.points = points;
    }

    private E thisRef() {
        return (E)this;
    }

    public E point(double longitude, double latitude) {
        return this.point(PointCollection.coordinate(longitude, latitude));
    }

    public E point(Coordinate coordinate) {
        this.points.add(coordinate);
        return this.thisRef();
    }

    public E points(Coordinate ... coordinates) {
        return this.points(Arrays.asList(coordinates));
    }

    public E points(Collection<? extends Coordinate> coordinates) {
        this.points.addAll(coordinates);
        return this.thisRef();
    }

    protected Coordinate[] coordinates(boolean closed) {
        Coordinate[] result = this.points.toArray(new Coordinate[this.points.size() + (closed ? 1 : 0)]);
        if (closed) {
            result[result.length - 1] = result[0];
        }
        return result;
    }

    protected XContentBuilder coordinatesToXcontent(XContentBuilder builder, boolean closed) throws IOException {
        builder.startArray();
        for (Coordinate point : this.points) {
            PointCollection.toXContent(builder, point);
        }
        if (closed) {
            Coordinate start = this.points.get(0);
            Coordinate end = this.points.get(this.points.size() - 1);
            if (start.x != end.x || start.y != end.y) {
                PointCollection.toXContent(builder, this.points.get(0));
            }
        }
        builder.endArray();
        return builder;
    }
}

