/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline.movavg.models;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.search.aggregations.pipeline.movavg.models.EwmaModel;
import org.elasticsearch.search.aggregations.pipeline.movavg.models.HoltLinearModel;
import org.elasticsearch.search.aggregations.pipeline.movavg.models.HoltWintersModel;
import org.elasticsearch.search.aggregations.pipeline.movavg.models.LinearModel;
import org.elasticsearch.search.aggregations.pipeline.movavg.models.MovAvgModel;
import org.elasticsearch.search.aggregations.pipeline.movavg.models.SimpleModel;

public class MovAvgModelStreams {
    private static Map<String, Stream> STREAMS = Collections.EMPTY_MAP;

    public static MovAvgModel read(StreamInput in) throws IOException {
        return MovAvgModelStreams.stream(in.readString()).readResult(in);
    }

    public static synchronized void registerStream(Stream stream) {
        if (STREAMS.containsKey(stream.getName())) {
            throw new IllegalArgumentException("Can't register stream with name [" + stream.getName() + "] more than once");
        }
        HashMap<String, Stream> map = new HashMap<String, Stream>();
        map.putAll(STREAMS);
        map.put(stream.getName(), stream);
        STREAMS = Collections.unmodifiableMap(map);
    }

    private static synchronized Stream stream(String name) {
        return STREAMS.get(name);
    }

    static {
        HashMap<String, Stream> map = new HashMap<String, Stream>();
        map.put(SimpleModel.STREAM.getName(), SimpleModel.STREAM);
        map.put(LinearModel.STREAM.getName(), LinearModel.STREAM);
        map.put(EwmaModel.STREAM.getName(), EwmaModel.STREAM);
        map.put(HoltLinearModel.STREAM.getName(), HoltLinearModel.STREAM);
        map.put(HoltWintersModel.STREAM.getName(), HoltWintersModel.STREAM);
        STREAMS = Collections.unmodifiableMap(map);
    }

    public static interface Stream {
        public MovAvgModel readResult(StreamInput var1) throws IOException;

        public String getName();
    }
}

