/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.rest.RestStatus;

public class ElasticsearchSecurityException
extends ElasticsearchException {
    private final RestStatus status;

    public ElasticsearchSecurityException(String msg, RestStatus status, Throwable cause, Object ... args) {
        super(msg, cause, args);
        this.status = status;
    }

    public ElasticsearchSecurityException(String msg, Throwable cause, Object ... args) {
        this(msg, ExceptionsHelper.status(cause), cause, args);
    }

    public ElasticsearchSecurityException(String msg, Object ... args) {
        this(msg, RestStatus.INTERNAL_SERVER_ERROR, null, args);
    }

    public ElasticsearchSecurityException(String msg, RestStatus status, Object ... args) {
        this(msg, status, null, args);
    }

    public ElasticsearchSecurityException(StreamInput in) throws IOException {
        super(in);
        this.status = RestStatus.readFrom(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        RestStatus.writeTo(out, this.status);
    }

    @Override
    public final RestStatus status() {
        return this.status;
    }
}

