/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty;

import org.elasticsearch.Version;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class NettyHeader {
    public static final int MARKER_BYTES_SIZE = 2;
    public static final int MESSAGE_LENGTH_SIZE = 4;
    public static final int REQUEST_ID_SIZE = 8;
    public static final int STATUS_SIZE = 1;
    public static final int VERSION_ID_SIZE = 4;
    public static final int HEADER_SIZE = 19;
    public static final int PING_DATA_SIZE = -1;
    private static final ChannelBuffer pingHeader = ChannelBuffers.buffer((int)6);

    public static ChannelBuffer pingHeader() {
        return pingHeader.duplicate();
    }

    public static void writeHeader(ChannelBuffer buffer, long requestId, byte status, Version version) {
        int index = buffer.readerIndex();
        buffer.setByte(index, 69);
        buffer.setByte(++index, 83);
        buffer.setInt(++index, buffer.readableBytes() - 2 - 4);
        buffer.setLong(index += 4, requestId);
        buffer.setByte(index += 8, (int)status);
        buffer.setInt(++index, version.id);
    }

    static {
        pingHeader.writeByte(69);
        pingHeader.writeByte(83);
        pingHeader.writeInt(-1);
    }
}

