/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.termvectors;

import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.Iterator;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.termvectors.MultiTermVectorsItemResponse;
import org.elasticsearch.action.termvectors.TermVectorsResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class MultiTermVectorsResponse
extends ActionResponse
implements Iterable<MultiTermVectorsItemResponse>,
ToXContent {
    private MultiTermVectorsItemResponse[] responses;

    MultiTermVectorsResponse() {
    }

    public MultiTermVectorsResponse(MultiTermVectorsItemResponse[] responses) {
        this.responses = responses;
    }

    public MultiTermVectorsItemResponse[] getResponses() {
        return this.responses;
    }

    @Override
    public Iterator<MultiTermVectorsItemResponse> iterator() {
        return Iterators.forArray((Object[])this.responses);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(Fields.DOCS);
        for (MultiTermVectorsItemResponse response : this.responses) {
            if (response.isFailed()) {
                builder.startObject();
                Failure failure = response.getFailure();
                builder.field(Fields._INDEX, failure.getIndex());
                builder.field(Fields._TYPE, failure.getType());
                builder.field(Fields._ID, failure.getId());
                ElasticsearchException.renderThrowable(builder, params, failure.getCause());
                builder.endObject();
                continue;
            }
            TermVectorsResponse getResponse = response.getResponse();
            builder.startObject();
            getResponse.toXContent(builder, params);
            builder.endObject();
        }
        builder.endArray();
        return builder;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.responses = new MultiTermVectorsItemResponse[in.readVInt()];
        for (int i = 0; i < this.responses.length; ++i) {
            this.responses[i] = MultiTermVectorsItemResponse.readItemResponse(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.responses.length);
        for (MultiTermVectorsItemResponse response : this.responses) {
            response.writeTo(out);
        }
    }

    static final class Fields {
        static final XContentBuilderString DOCS = new XContentBuilderString("docs");
        static final XContentBuilderString _INDEX = new XContentBuilderString("_index");
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString _ID = new XContentBuilderString("_id");

        Fields() {
        }
    }

    public static class Failure
    implements Streamable {
        private String index;
        private String type;
        private String id;
        private Throwable cause;

        Failure() {
        }

        public Failure(String index, String type, String id, Throwable cause) {
            this.index = index;
            this.type = type;
            this.id = id;
            this.cause = cause;
        }

        public String getIndex() {
            return this.index;
        }

        public String getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public Throwable getCause() {
            return this.cause;
        }

        public static Failure readFailure(StreamInput in) throws IOException {
            Failure failure = new Failure();
            failure.readFrom(in);
            return failure;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.index = in.readString();
            this.type = in.readOptionalString();
            this.id = in.readString();
            this.cause = in.readThrowable();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.index);
            out.writeOptionalString(this.type);
            out.writeString(this.id);
            out.writeThrowable(this.cause);
        }
    }
}

