/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.status;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;

public class SnapshotStats
implements Streamable,
ToXContent {
    private long startTime;
    private long time;
    private int numberOfFiles;
    private int processedFiles;
    private long totalSize;
    private long processedSize;

    SnapshotStats() {
    }

    SnapshotStats(IndexShardSnapshotStatus indexShardStatus) {
        this.startTime = indexShardStatus.startTime();
        this.time = indexShardStatus.time();
        this.numberOfFiles = indexShardStatus.numberOfFiles();
        this.processedFiles = indexShardStatus.processedFiles();
        this.totalSize = indexShardStatus.totalSize();
        this.processedSize = indexShardStatus.processedSize();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getTime() {
        return this.time;
    }

    public int getNumberOfFiles() {
        return this.numberOfFiles;
    }

    public int getProcessedFiles() {
        return this.processedFiles;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public long getProcessedSize() {
        return this.processedSize;
    }

    public static SnapshotStats readSnapshotStats(StreamInput in) throws IOException {
        SnapshotStats stats = new SnapshotStats();
        stats.readFrom(in);
        return stats;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.startTime);
        out.writeVLong(this.time);
        out.writeVInt(this.numberOfFiles);
        out.writeVInt(this.processedFiles);
        out.writeVLong(this.totalSize);
        out.writeVLong(this.processedSize);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.startTime = in.readVLong();
        this.time = in.readVLong();
        this.numberOfFiles = in.readVInt();
        this.processedFiles = in.readVInt();
        this.totalSize = in.readVLong();
        this.processedSize = in.readVLong();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("stats");
        builder.field("number_of_files", this.getNumberOfFiles());
        builder.field("processed_files", this.getProcessedFiles());
        builder.byteSizeField("total_size_in_bytes", "total_size", this.getTotalSize());
        builder.byteSizeField("processed_size_in_bytes", "processed_size", this.getProcessedSize());
        builder.field("start_time_in_millis", this.getStartTime());
        builder.timeValueField("time_in_millis", "time", this.getTime());
        builder.endObject();
        return builder;
    }

    void add(SnapshotStats stats) {
        this.numberOfFiles += stats.numberOfFiles;
        this.processedFiles += stats.processedFiles;
        this.totalSize += stats.totalSize;
        this.processedSize += stats.processedSize;
        if (this.startTime == 0L) {
            this.startTime = stats.startTime;
            this.time = stats.time;
        } else {
            long endTime = Math.max(this.startTime + this.time, stats.startTime + stats.time);
            this.startTime = Math.min(this.startTime, stats.startTime);
            this.time = endTime - this.startTime;
        }
    }

    static final class Fields {
        static final String STATS = "stats";
        static final String NUMBER_OF_FILES = "number_of_files";
        static final String PROCESSED_FILES = "processed_files";
        static final String TOTAL_SIZE_IN_BYTES = "total_size_in_bytes";
        static final String TOTAL_SIZE = "total_size";
        static final String PROCESSED_SIZE_IN_BYTES = "processed_size_in_bytes";
        static final String PROCESSED_SIZE = "processed_size";
        static final String START_TIME_IN_MILLIS = "start_time_in_millis";
        static final String TIME_IN_MILLIS = "time_in_millis";
        static final String TIME = "time";

        Fields() {
        }
    }
}

