/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldstats;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.fieldstats.FieldStats;
import org.elasticsearch.action.fieldstats.FieldStatsRequest;
import org.elasticsearch.action.fieldstats.FieldStatsResponse;
import org.elasticsearch.action.fieldstats.FieldStatsShardRequest;
import org.elasticsearch.action.fieldstats.FieldStatsShardResponse;
import org.elasticsearch.action.fieldstats.IndexConstraint;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.TransportBroadcastAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportFieldStatsAction
extends TransportBroadcastAction<FieldStatsRequest, FieldStatsResponse, FieldStatsShardRequest, FieldStatsShardResponse> {
    private final IndicesService indicesService;

    @Inject
    public TransportFieldStatsAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService) {
        super(settings, "indices:data/read/field_stats", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, FieldStatsRequest::new, FieldStatsShardRequest::new, "management");
        this.indicesService = indicesService;
    }

    @Override
    protected FieldStatsResponse newResponse(FieldStatsRequest request, AtomicReferenceArray shardsResponses, ClusterState clusterState) {
        int successfulShards = 0;
        int failedShards = 0;
        HashMap<String, String> conflicts = new HashMap<String, String>();
        HashMap<String, Map<String, FieldStats>> indicesMergedFieldStats = new HashMap<String, Map<String, FieldStats>>();
        ArrayList<ShardOperationFailedException> shardFailures = new ArrayList<ShardOperationFailedException>();
        for (int i = 0; i < shardsResponses.length(); ++i) {
            Object shardValue = shardsResponses.get(i);
            if (shardValue != null) {
                if (shardValue instanceof BroadcastShardOperationFailedException) {
                    ++failedShards;
                    shardFailures.add(new DefaultShardOperationFailedException((BroadcastShardOperationFailedException)shardValue));
                } else {
                    String indexName;
                    ++successfulShards;
                    FieldStatsShardResponse shardResponse = (FieldStatsShardResponse)shardValue;
                    if ("cluster".equals(request.level())) {
                        indexName = "_all";
                    } else if ("indices".equals(request.level())) {
                        indexName = shardResponse.getIndex();
                    } else {
                        throw new IllegalArgumentException("Illegal level option [" + request.level() + "]");
                    }
                    HashMap indexMergedFieldStats = (HashMap)indicesMergedFieldStats.get(indexName);
                    if (indexMergedFieldStats == null) {
                        indexMergedFieldStats = new HashMap();
                        indicesMergedFieldStats.put(indexName, indexMergedFieldStats);
                    }
                    Map<String, FieldStats<?>> fieldStats = shardResponse.getFieldStats();
                    for (Map.Entry<String, FieldStats<?>> entry : fieldStats.entrySet()) {
                        FieldStats existing = (FieldStats)indexMergedFieldStats.get(entry.getKey());
                        if (existing != null) {
                            if (existing.getType() != entry.getValue().getType()) {
                                if (conflicts.containsKey(entry.getKey())) continue;
                                FieldStats[] fields = new FieldStats[]{entry.getValue(), existing};
                                Arrays.sort(fields, (o1, o2) -> Byte.compare(o1.getType(), o2.getType()));
                                conflicts.put(entry.getKey(), "Field [" + entry.getKey() + "] of type [" + fields[0].getDisplayType() + "] conflicts with existing field of type [" + fields[1].getDisplayType() + "] in other index.");
                                continue;
                            }
                            existing.accumulate(entry.getValue());
                            continue;
                        }
                        indexMergedFieldStats.put(entry.getKey(), entry.getValue());
                    }
                }
            }
            for (String conflictKey : conflicts.keySet()) {
                for (Map.Entry entry : indicesMergedFieldStats.entrySet()) {
                    if (!((Map)entry.getValue()).containsKey(conflictKey)) continue;
                    ((Map)entry.getValue()).remove(conflictKey);
                }
            }
        }
        if (request.getIndexConstraints().length != 0) {
            HashSet<String> fieldStatFields = new HashSet<String>(Arrays.asList(request.getFields()));
            for (IndexConstraint indexConstraint : request.getIndexConstraints()) {
                Iterator iterator = indicesMergedFieldStats.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    FieldStats indexConstraintFieldStats = (FieldStats)((Map)entry.getValue()).get(indexConstraint.getField());
                    if (indexConstraintFieldStats != null && indexConstraintFieldStats.match(indexConstraint)) {
                        if (fieldStatFields.contains(indexConstraint.getField())) continue;
                        ((Map)entry.getValue()).remove(indexConstraint.getField());
                        continue;
                    }
                    iterator.remove();
                }
            }
        }
        return new FieldStatsResponse(shardsResponses.length(), successfulShards, failedShards, shardFailures, indicesMergedFieldStats, conflicts);
    }

    @Override
    protected FieldStatsShardRequest newShardRequest(int numShards, ShardRouting shard, FieldStatsRequest request) {
        return new FieldStatsShardRequest(shard.shardId(), request);
    }

    @Override
    protected FieldStatsShardResponse newShardResponse() {
        return new FieldStatsShardResponse();
    }

    @Override
    protected FieldStatsShardResponse shardOperation(FieldStatsShardRequest request) {
        ShardId shardId = request.shardId();
        HashMap fieldStats = new HashMap();
        IndexService indexServices = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard shard = indexServices.getShard(shardId.id());
        try (Engine.Searcher searcher = shard.acquireSearcher("fieldstats");){
            HashSet<String> fieldNames = new HashSet<String>();
            for (String field : request.getFields()) {
                fieldNames.addAll(shard.mapperService().simpleMatchToIndexNames(field));
            }
            for (String field : fieldNames) {
                FieldStats<?> stats = this.indicesService.getFieldStats(shard, searcher, field, request.shouldUseCache());
                if (stats == null) continue;
                fieldStats.put(field, stats);
            }
        }
        catch (Exception e) {
            throw ExceptionsHelper.convertToElastic(e);
        }
        return new FieldStatsShardResponse(shardId, fieldStats);
    }

    @Override
    protected GroupShardsIterator shards(ClusterState clusterState, FieldStatsRequest request, String[] concreteIndices) {
        return this.clusterService.operationRouting().searchShards(clusterState, concreteIndices, null, null);
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, FieldStatsRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.READ);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, FieldStatsRequest request, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.READ, concreteIndices);
    }
}

