/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.mapping.put;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.RequestValidators;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetadataMappingService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportPutMappingAction
extends AcknowledgedTransportMasterNodeAction<PutMappingRequest> {
    private static final Logger logger = LogManager.getLogger(TransportPutMappingAction.class);
    private final MetadataMappingService metadataMappingService;
    private final RequestValidators<PutMappingRequest> requestValidators;
    private final SystemIndices systemIndices;

    @Inject
    public TransportPutMappingAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataMappingService metadataMappingService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, RequestValidators<PutMappingRequest> requestValidators, SystemIndices systemIndices) {
        super("indices:admin/mapping/put", transportService, clusterService, threadPool, actionFilters, PutMappingRequest::new, indexNameExpressionResolver, "same");
        this.metadataMappingService = metadataMappingService;
        this.requestValidators = Objects.requireNonNull(requestValidators);
        this.systemIndices = systemIndices;
    }

    @Override
    protected ClusterBlockException checkBlock(PutMappingRequest request, ClusterState state) {
        String[] indices = request.getConcreteIndex() == null ? this.indexNameExpressionResolver.concreteIndexNames(state, request) : new String[]{request.getConcreteIndex().getName()};
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, indices);
    }

    @Override
    protected void masterOperation(PutMappingRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        try {
            Index[] concreteIndices = TransportPutMappingAction.resolveIndices(state, request, this.indexNameExpressionResolver);
            String mappingSource = request.source();
            Optional<Exception> maybeValidationException = this.requestValidators.validateRequest(request, state, concreteIndices);
            if (maybeValidationException.isPresent()) {
                listener.onFailure(maybeValidationException.get());
                return;
            }
            List<String> violations = this.checkForSystemIndexViolations(concreteIndices, mappingSource);
            if (!violations.isEmpty()) {
                String message = "Cannot update mappings in " + violations + ": system indices can only use mappings from their descriptors, but the mappings in the request did not match those in the descriptors(s)";
                logger.warn(message);
                listener.onFailure(new IllegalArgumentException(message));
                return;
            }
            TransportPutMappingAction.performMappingUpdate(concreteIndices, request, listener, this.metadataMappingService);
        }
        catch (IndexNotFoundException ex) {
            logger.debug(() -> new ParameterizedMessage("failed to put mappings on indices [{}], type [{}]", (Object)request.indices(), (Object)request.type()), (Throwable)ex);
            throw ex;
        }
    }

    static Index[] resolveIndices(ClusterState state, PutMappingRequest request, IndexNameExpressionResolver iner) {
        if (request.getConcreteIndex() == null) {
            if (request.writeIndexOnly()) {
                ArrayList<Index> indices = new ArrayList<Index>();
                for (String indexExpression : request.indices()) {
                    indices.add(iner.concreteWriteIndex(state, request.indicesOptions(), indexExpression, request.indicesOptions().allowNoIndices(), request.includeDataStreams()));
                }
                return indices.toArray(Index.EMPTY_ARRAY);
            }
            return iner.concreteIndices(state, request);
        }
        return new Index[]{request.getConcreteIndex()};
    }

    static void performMappingUpdate(final Index[] concreteIndices, PutMappingRequest request, final ActionListener<AcknowledgedResponse> listener, MetadataMappingService metadataMappingService) {
        PutMappingClusterStateUpdateRequest updateRequest = ((PutMappingClusterStateUpdateRequest)((PutMappingClusterStateUpdateRequest)((PutMappingClusterStateUpdateRequest)new PutMappingClusterStateUpdateRequest().ackTimeout(request.timeout())).masterNodeTimeout(request.masterNodeTimeout())).indices(concreteIndices)).type(request.type()).source(request.source());
        metadataMappingService.putMapping(updateRequest, new ActionListener<AcknowledgedResponse>(){

            @Override
            public void onResponse(AcknowledgedResponse response) {
                listener.onResponse(response);
            }

            @Override
            public void onFailure(Exception t) {
                logger.debug(() -> new ParameterizedMessage("failed to put mappings on indices [{}]", Arrays.asList(concreteIndices)), (Throwable)t);
                listener.onFailure(t);
            }
        });
    }

    private List<String> checkForSystemIndexViolations(Index[] concreteIndices, String requestMappings) {
        ArrayList<String> violations = new ArrayList<String>();
        for (Index index : concreteIndices) {
            String descriptorMappings;
            SystemIndexDescriptor descriptor = this.systemIndices.findMatchingDescriptor(index.getName());
            if (descriptor == null || !descriptor.isAutomaticallyManaged() || (descriptorMappings = descriptor.getMappings()).equals(requestMappings)) continue;
            violations.add(index.getName());
        }
        return violations;
    }
}

