/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.suggest.document.Completion84PostingsFormat;
import org.apache.lucene.search.suggest.document.CompletionAnalyzer;
import org.apache.lucene.search.suggest.document.CompletionQuery;
import org.apache.lucene.search.suggest.document.FuzzyCompletionQuery;
import org.apache.lucene.search.suggest.document.PrefixCompletionQuery;
import org.apache.lucene.search.suggest.document.RegexCompletionQuery;
import org.apache.lucene.search.suggest.document.SuggestField;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.ArraySourceValueFetcher;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.TermBasedFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.suggest.completion.context.ContextMapping;
import org.elasticsearch.search.suggest.completion.context.ContextMappings;

public class CompletionFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "completion";
    static final int COMPLETION_CONTEXTS_LIMIT = 10;
    public static final Set<String> ALLOWED_CONTENT_FIELD_NAMES = Sets.newHashSet("input", "weight", "contexts");
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, c.getIndexAnalyzers().get("simple"), c.indexVersionCreated()));
    private final int maxInputLength;
    private final Builder builder;

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.builder.defaultAnalyzer, this.builder.indexVersionCreated).init(this);
    }

    private static Builder builder(FieldMapper in) {
        return ((CompletionFieldMapper)in).builder;
    }

    public CompletionFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Builder builder) {
        super(simpleName, mappedFieldType, builder.buildAnalyzer(), multiFields, copyTo);
        this.builder = builder;
        this.maxInputLength = (Integer)builder.maxInputLength.getValue();
    }

    @Override
    public CompletionFieldType fieldType() {
        return (CompletionFieldType)super.fieldType();
    }

    @Override
    public boolean parsesArrayValue() {
        return true;
    }

    int getMaxInputLength() {
        return (Integer)this.builder.maxInputLength.get();
    }

    @Override
    public void parse(ParseContext context) throws IOException {
        XContentParser parser = context.parser();
        XContentParser.Token token = parser.currentToken();
        Map<Object, Object> inputMap = new HashMap(1);
        if (context.externalValueSet()) {
            inputMap = this.getInputMapFromExternalValue(context);
        } else {
            if (token == XContentParser.Token.VALUE_NULL) {
                return;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    this.parse(context, token, parser, inputMap);
                }
            } else {
                this.parse(context, token, parser, inputMap);
            }
        }
        for (Map.Entry<Object, Object> entry : inputMap.entrySet()) {
            String input = (String)entry.getKey();
            if (input.trim().isEmpty()) {
                context.addIgnoredField(this.mappedFieldType.name());
                continue;
            }
            if (input.length() > this.maxInputLength) {
                int len = this.maxInputLength;
                if (Character.isHighSurrogate(input.charAt(len - 1))) {
                    assert (input.length() >= len + 1 && Character.isLowSurrogate(input.charAt(len)));
                    ++len;
                }
                input = input.substring(0, len);
            }
            CompletionInputMetadata metadata = (CompletionInputMetadata)entry.getValue();
            if (this.fieldType().hasContextMappings()) {
                this.fieldType().getContextMappings().addField(context.doc(), this.fieldType().name(), input, metadata.weight, metadata.contexts);
                continue;
            }
            context.doc().add((IndexableField)new SuggestField(this.fieldType().name(), input, metadata.weight));
        }
        this.createFieldNamesField(context);
        for (CompletionInputMetadata completionInputMetadata : inputMap.values()) {
            ParseContext externalValueContext = context.createExternalValueContext(completionInputMetadata);
            this.multiFields.parse(this, externalValueContext);
        }
    }

    private Map<String, CompletionInputMetadata> getInputMapFromExternalValue(ParseContext context) {
        Map<String, CompletionInputMetadata> inputMap;
        if (this.isExternalValueOfClass(context, CompletionInputMetadata.class)) {
            CompletionInputMetadata inputAndMeta = (CompletionInputMetadata)context.externalValue();
            inputMap = Collections.singletonMap(inputAndMeta.input, inputAndMeta);
        } else {
            String fieldName = context.externalValue().toString();
            inputMap = Collections.singletonMap(fieldName, new CompletionInputMetadata(fieldName, Collections.emptyMap(), 1));
        }
        return inputMap;
    }

    private boolean isExternalValueOfClass(ParseContext context, Class<?> clazz) {
        return context.externalValue().getClass().equals(clazz);
    }

    private void parse(ParseContext parseContext, XContentParser.Token token, XContentParser parser, Map<String, CompletionInputMetadata> inputMap) throws IOException {
        String currentFieldName = null;
        if (token == XContentParser.Token.VALUE_STRING) {
            inputMap.put(parser.text(), new CompletionInputMetadata(parser.text(), Collections.emptyMap(), 1));
        } else if (token == XContentParser.Token.START_OBJECT) {
            HashSet<String> inputs = new HashSet<String>();
            int weight = 1;
            HashMap<String, Set<String>> contextsMap = new HashMap<String, Set<String>>();
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    if (ALLOWED_CONTENT_FIELD_NAMES.contains(currentFieldName)) continue;
                    throw new IllegalArgumentException("unknown field name [" + currentFieldName + "], must be one of " + ALLOWED_CONTENT_FIELD_NAMES);
                }
                if (currentFieldName == null) continue;
                if ("input".equals(currentFieldName)) {
                    if (token == XContentParser.Token.VALUE_STRING) {
                        inputs.add(parser.text());
                        continue;
                    }
                    if (token == XContentParser.Token.START_ARRAY) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            if (token == XContentParser.Token.VALUE_STRING) {
                                inputs.add(parser.text());
                                continue;
                            }
                            throw new IllegalArgumentException("input array must have string values, but was [" + token.name() + "]");
                        }
                        continue;
                    }
                    throw new IllegalArgumentException("input must be a string or array, but was [" + token.name() + "]");
                }
                if ("weight".equals(currentFieldName)) {
                    Number weightValue;
                    if (token == XContentParser.Token.VALUE_STRING) {
                        try {
                            weightValue = Long.parseLong(parser.text());
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException("weight must be an integer, but was [" + parser.text() + "]");
                        }
                    } else if (token == XContentParser.Token.VALUE_NUMBER) {
                        XContentParser.NumberType numberType = parser.numberType();
                        if (XContentParser.NumberType.LONG != numberType && XContentParser.NumberType.INT != numberType) {
                            throw new IllegalArgumentException("weight must be an integer, but was [" + parser.numberValue() + "]");
                        }
                        weightValue = parser.numberValue();
                    } else {
                        throw new IllegalArgumentException("weight must be a number or string, but was [" + token.name() + "]");
                    }
                    if (weightValue.longValue() < 0L || weightValue.longValue() > Integer.MAX_VALUE) {
                        throw new IllegalArgumentException("weight must be in the interval [0..2147483647], but was [" + weightValue.longValue() + "]");
                    }
                    weight = weightValue.intValue();
                    continue;
                }
                if (!"contexts".equals(currentFieldName)) continue;
                if (!this.fieldType().hasContextMappings()) {
                    throw new IllegalArgumentException("contexts field is not supported for field: [" + this.fieldType().name() + "]");
                }
                ContextMappings contextMappings = this.fieldType().getContextMappings();
                XContentParser.Token currentToken = parser.currentToken();
                if (currentToken == XContentParser.Token.START_OBJECT) {
                    ContextMapping<?> contextMapping = null;
                    String fieldName = null;
                    while ((currentToken = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (currentToken == XContentParser.Token.FIELD_NAME) {
                            fieldName = parser.currentName();
                            contextMapping = contextMappings.get(fieldName);
                            continue;
                        }
                        assert (fieldName != null);
                        assert (!contextsMap.containsKey(fieldName));
                        contextsMap.put(fieldName, contextMapping.parseContext(parseContext, parser));
                    }
                    continue;
                }
                throw new IllegalArgumentException("contexts must be an object or an array , but was [" + currentToken + "]");
            }
            for (String input : inputs) {
                if (inputMap.containsKey(input) && inputMap.get((Object)input).weight >= weight) continue;
                inputMap.put(input, new CompletionInputMetadata(input, contextsMap, weight));
            }
        } else {
            throw new ParsingException(parser.getTokenLocation(), "failed to parse [" + parser.currentName() + "]: expected text or object, but got " + token.name(), new Object[0]);
        }
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public void doValidate(MappingLookup mappers) {
        if (this.fieldType().hasContextMappings()) {
            for (ContextMapping<?> contextMapping : this.fieldType().getContextMappings()) {
                contextMapping.validateReferences(this.builder.indexVersionCreated, s -> mappers.fieldTypes().get((String)s));
            }
        }
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<NamedAnalyzer> analyzer;
        private final FieldMapper.Parameter<NamedAnalyzer> searchAnalyzer;
        private final FieldMapper.Parameter<Boolean> preserveSeparators = FieldMapper.Parameter.boolParam("preserve_separators", false, m -> CompletionFieldMapper.builder((FieldMapper)m).preserveSeparators.get(), true).alwaysSerialize();
        private final FieldMapper.Parameter<Boolean> preservePosInc = FieldMapper.Parameter.boolParam("preserve_position_increments", false, m -> CompletionFieldMapper.builder((FieldMapper)m).preservePosInc.get(), true).alwaysSerialize();
        private final FieldMapper.Parameter<ContextMappings> contexts = new FieldMapper.Parameter<ContextMappings>("contexts", false, () -> null, (n, c, o) -> ContextMappings.load(o), m -> CompletionFieldMapper.builder((FieldMapper)m).contexts.get()).setSerializer((b, n, c) -> {
            if (c == null) {
                return;
            }
            b.startArray(n);
            c.toXContent(b, ToXContent.EMPTY_PARAMS);
            b.endArray();
        }, Objects::toString);
        private final FieldMapper.Parameter<Integer> maxInputLength = FieldMapper.Parameter.intParam("max_input_length", true, m -> CompletionFieldMapper.builder((FieldMapper)m).maxInputLength.get(), 50).addDeprecatedName("max_input_len").setValidator(Builder::validateInputLength).alwaysSerialize();
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final NamedAnalyzer defaultAnalyzer;
        private final Version indexVersionCreated;
        private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(Builder.class);

        public Builder(String name, NamedAnalyzer defaultAnalyzer, Version indexVersionCreated) {
            super(name);
            this.defaultAnalyzer = defaultAnalyzer;
            this.indexVersionCreated = indexVersionCreated;
            this.analyzer = FieldMapper.Parameter.analyzerParam("analyzer", false, m -> CompletionFieldMapper.builder((FieldMapper)m).analyzer.get(), () -> defaultAnalyzer).alwaysSerialize();
            this.searchAnalyzer = FieldMapper.Parameter.analyzerParam("search_analyzer", true, m -> CompletionFieldMapper.builder((FieldMapper)m).searchAnalyzer.get(), this.analyzer::getValue);
        }

        private static void validateInputLength(int maxInputLength) {
            if (maxInputLength <= 0) {
                throw new IllegalArgumentException("[max_input_length] must be > 0 but was [" + maxInputLength + "]");
            }
        }

        @Override
        protected List<FieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.analyzer, this.searchAnalyzer, this.preserveSeparators, this.preservePosInc, this.maxInputLength, this.contexts, this.meta);
        }

        NamedAnalyzer buildAnalyzer() {
            return new NamedAnalyzer(this.analyzer.get().name(), AnalyzerScope.INDEX, (Analyzer)new CompletionAnalyzer((Analyzer)this.analyzer.get(), this.preserveSeparators.get().booleanValue(), this.preservePosInc.get().booleanValue()));
        }

        @Override
        public CompletionFieldMapper build(ContentPath contentPath) {
            this.checkCompletionContextsLimit();
            NamedAnalyzer completionAnalyzer = new NamedAnalyzer(this.searchAnalyzer.getValue().name(), AnalyzerScope.INDEX, (Analyzer)new CompletionAnalyzer((Analyzer)this.searchAnalyzer.getValue(), this.preserveSeparators.getValue().booleanValue(), this.preservePosInc.getValue().booleanValue()));
            CompletionFieldType ft = new CompletionFieldType(this.buildFullName(contentPath), completionAnalyzer, this.meta.getValue());
            ft.setContextMappings(this.contexts.getValue());
            return new CompletionFieldMapper(this.name, (MappedFieldType)ft, this.multiFieldsBuilder.build(this, contentPath), this.copyTo.build(), this);
        }

        private void checkCompletionContextsLimit() {
            if (this.contexts.getValue() != null && this.contexts.getValue().size() > 10) {
                deprecationLogger.deprecate("excessive_completion_contexts", "You have defined more than [10] completion contexts in the mapping for field [" + this.name() + "]. The maximum allowed number of completion contexts in a mapping will be limited to [" + 10 + "] starting in version [8.0].", new Object[0]);
            }
        }
    }

    public static final class CompletionFieldType
    extends TermBasedFieldType {
        private static PostingsFormat postingsFormat;
        private ContextMappings contextMappings = null;

        public CompletionFieldType(String name, NamedAnalyzer searchAnalyzer, Map<String, String> meta) {
            super(name, true, false, false, new TextSearchInfo(Defaults.FIELD_TYPE, null, searchAnalyzer, searchAnalyzer), meta);
        }

        public void setContextMappings(ContextMappings contextMappings) {
            this.contextMappings = contextMappings;
        }

        public boolean hasContextMappings() {
            return this.contextMappings != null;
        }

        public ContextMappings getContextMappings() {
            return this.contextMappings;
        }

        public static synchronized PostingsFormat postingsFormat() {
            if (postingsFormat == null) {
                postingsFormat = new Completion84PostingsFormat();
            }
            return postingsFormat;
        }

        public CompletionQuery prefixQuery(Object value) {
            return new PrefixCompletionQuery(this.getTextSearchInfo().getSearchAnalyzer().analyzer(), new Term(this.name(), this.indexedValueForSearch(value)));
        }

        public CompletionQuery regexpQuery(Object value, int flags, int maxDeterminizedStates) {
            return new RegexCompletionQuery(new Term(this.name(), this.indexedValueForSearch(value)), flags, maxDeterminizedStates);
        }

        public CompletionQuery fuzzyQuery(String value, Fuzziness fuzziness, int nonFuzzyPrefixLength, int minFuzzyPrefixLength, int maxExpansions, boolean transpositions, boolean unicodeAware) {
            return new FuzzyCompletionQuery(this.getTextSearchInfo().getSearchAnalyzer().analyzer(), new Term(this.name(), this.indexedValueForSearch(value)), null, fuzziness.asDistance(), transpositions, nonFuzzyPrefixLength, minFuzzyPrefixLength, unicodeAware, maxExpansions);
        }

        @Override
        public String typeName() {
            return CompletionFieldMapper.CONTENT_TYPE;
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new ArraySourceValueFetcher(this.name(), context){

                @Override
                protected List<?> parseSourceValue(Object value) {
                    if (value instanceof List) {
                        return (List)value;
                    }
                    return Collections.singletonList(value);
                }
            };
        }
    }

    static class CompletionInputMetadata {
        public final String input;
        public final Map<String, Set<String>> contexts;
        public final int weight;

        CompletionInputMetadata(String input, Map<String, Set<String>> contexts, int weight) {
            this.input = input;
            this.contexts = contexts;
            this.weight = weight;
        }

        public String toString() {
            return this.input;
        }
    }

    public static class Fields {
        public static final String CONTENT_FIELD_NAME_INPUT = "input";
        public static final String CONTENT_FIELD_NAME_WEIGHT = "weight";
        public static final String CONTENT_FIELD_NAME_CONTEXTS = "contexts";
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();
        public static final boolean DEFAULT_PRESERVE_SEPARATORS = true;
        public static final boolean DEFAULT_POSITION_INCREMENTS = true;
        public static final int DEFAULT_MAX_INPUT_LENGTH = 50;

        static {
            FIELD_TYPE.setTokenized(true);
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setStoreTermVectors(false);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.freeze();
        }
    }
}

