/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.DocumentParser;
import org.elasticsearch.index.mapper.IdFieldMapper;
import org.elasticsearch.index.mapper.IndexFieldMapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.RootObjectMapper;
import org.elasticsearch.index.mapper.RoutingFieldMapper;
import org.elasticsearch.index.mapper.SourceFieldMapper;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.TypeFieldMapper;

public class DocumentMapper
implements ToXContentFragment {
    private final String type;
    private final Text typeText;
    private final CompressedXContent mappingSource;
    private final Mapping mapping;
    private final DocumentParser documentParser;
    private final MappingLookup fieldMappers;
    private final IndexSettings indexSettings;
    private final IndexAnalyzers indexAnalyzers;
    private final MetadataFieldMapper[] deleteTombstoneMetadataFieldMappers;
    private final MetadataFieldMapper[] noopTombstoneMetadataFieldMappers;

    private DocumentMapper(IndexSettings indexSettings, IndexAnalyzers indexAnalyzers, DocumentParser documentParser, Mapping mapping) {
        this.type = mapping.root().name();
        this.typeText = new Text(this.type);
        this.mapping = mapping;
        this.documentParser = documentParser;
        this.indexSettings = indexSettings;
        this.indexAnalyzers = indexAnalyzers;
        this.fieldMappers = MappingLookup.fromMapping(mapping, this::parse);
        try {
            this.mappingSource = new CompressedXContent((ToXContent)this, XContentType.JSON, ToXContent.EMPTY_PARAMS);
        }
        catch (Exception e) {
            throw new ElasticsearchGenerationException("failed to serialize source for type [" + this.type + "]", e);
        }
        List<String> deleteTombstoneMetadataFields = Arrays.asList("_version", "_id", "_type", "_seq_no", "_primary_term", "_tombstone");
        this.deleteTombstoneMetadataFieldMappers = (MetadataFieldMapper[])Stream.of(mapping.metadataMappers).filter(field -> deleteTombstoneMetadataFields.contains(field.name())).toArray(MetadataFieldMapper[]::new);
        List<String> noopTombstoneMetadataFields = Arrays.asList("_version", "_seq_no", "_primary_term", "_tombstone");
        this.noopTombstoneMetadataFieldMappers = (MetadataFieldMapper[])Stream.of(mapping.metadataMappers).filter(field -> noopTombstoneMetadataFields.contains(field.name())).toArray(MetadataFieldMapper[]::new);
    }

    IndexSettings indexSettings() {
        return this.indexSettings;
    }

    IndexAnalyzers indexAnalyzers() {
        return this.indexAnalyzers;
    }

    public Mapping mapping() {
        return this.mapping;
    }

    public String type() {
        return this.type;
    }

    public Text typeText() {
        return this.typeText;
    }

    public Map<String, Object> meta() {
        return this.mapping.meta;
    }

    public CompressedXContent mappingSource() {
        return this.mappingSource;
    }

    public RootObjectMapper root() {
        return this.mapping.root;
    }

    public <T extends MetadataFieldMapper> T metadataMapper(Class<T> type) {
        return this.mapping.metadataMapper(type);
    }

    public IndexFieldMapper indexMapper() {
        return this.metadataMapper(IndexFieldMapper.class);
    }

    public TypeFieldMapper typeMapper() {
        return this.metadataMapper(TypeFieldMapper.class);
    }

    public SourceFieldMapper sourceMapper() {
        return this.metadataMapper(SourceFieldMapper.class);
    }

    public IdFieldMapper idFieldMapper() {
        return this.metadataMapper(IdFieldMapper.class);
    }

    public RoutingFieldMapper routingFieldMapper() {
        return this.metadataMapper(RoutingFieldMapper.class);
    }

    public IndexFieldMapper IndexFieldMapper() {
        return this.metadataMapper(IndexFieldMapper.class);
    }

    public boolean hasNestedObjects() {
        return this.mappers().hasNested();
    }

    public MappingLookup mappers() {
        return this.fieldMappers;
    }

    public ParsedDocument parse(SourceToParse source) throws MapperParsingException {
        return this.documentParser.parseDocument(source, this.mapping.metadataMappers, this);
    }

    public ParsedDocument createDeleteTombstoneDoc(String index, String type, String id) throws MapperParsingException {
        SourceToParse emptySource = new SourceToParse(index, type, id, new BytesArray("{}"), XContentType.JSON);
        return this.documentParser.parseDocument(emptySource, this.deleteTombstoneMetadataFieldMappers, this).toTombstone();
    }

    public ParsedDocument createNoopTombstoneDoc(String index, String reason) throws MapperParsingException {
        String id = "";
        SourceToParse sourceToParse = new SourceToParse(index, this.type, "", new BytesArray("{}"), XContentType.JSON);
        ParsedDocument parsedDoc = this.documentParser.parseDocument(sourceToParse, this.noopTombstoneMetadataFieldMappers, this).toTombstone();
        BytesRef byteRef = new BytesRef((CharSequence)reason);
        parsedDoc.rootDoc().add((IndexableField)new StoredField("_source", byteRef.bytes, byteRef.offset, byteRef.length));
        return parsedDoc;
    }

    public boolean hasNonNestedParent(String path) {
        ObjectMapper mapper = this.mappers().objectMappers().get(path);
        if (mapper == null) {
            return false;
        }
        while (mapper != null) {
            if (!mapper.nested().isNested()) {
                return true;
            }
            if (!path.contains(".")) {
                return false;
            }
            path = path.substring(0, path.lastIndexOf("."));
            mapper = this.mappers().objectMappers().get(path);
        }
        return false;
    }

    public List<ObjectMapper> getNestedMappers() {
        ArrayList<ObjectMapper> childMappers = new ArrayList<ObjectMapper>();
        for (ObjectMapper mapper : this.mappers().objectMappers().values()) {
            if (!mapper.nested().isNested()) continue;
            childMappers.add(mapper);
        }
        return childMappers;
    }

    public List<ObjectMapper> getNestedParentMappers() {
        ArrayList<ObjectMapper> parents = new ArrayList<ObjectMapper>();
        for (ObjectMapper mapper : this.mappers().objectMappers().values()) {
            ObjectMapper parent;
            String nestedParentPath = this.getNestedParent(mapper.fullPath());
            if (nestedParentPath == null || !(parent = this.mappers().objectMappers().get(nestedParentPath)).nested().isNested()) continue;
            parents.add(parent);
        }
        return parents;
    }

    public String getNestedParent(String path) {
        ObjectMapper mapper = this.mappers().objectMappers().get(path);
        if (mapper == null) {
            return null;
        }
        if (!path.contains(".")) {
            return null;
        }
        do {
            path = path.substring(0, path.lastIndexOf("."));
            mapper = this.mappers().objectMappers().get(path);
            if (mapper == null) {
                return null;
            }
            if (!mapper.nested().isNested()) continue;
            return path;
        } while (path.contains("."));
        return null;
    }

    public DocumentMapper merge(Mapping mapping, MapperService.MergeReason reason) {
        Mapping merged = this.mapping.merge(mapping, reason);
        return new DocumentMapper(this.indexSettings, this.indexAnalyzers, this.documentParser, merged);
    }

    public void validate(IndexSettings settings, boolean checkLimits) {
        this.mapping.validate(this.fieldMappers);
        if (settings.getIndexMetadata().isRoutingPartitionedIndex() && !this.routingFieldMapper().required()) {
            throw new IllegalArgumentException("mapping type [" + this.type() + "] must have routing required for partitioned index [" + settings.getIndex().getName() + "]");
        }
        if (settings.getIndexSortConfig().hasIndexSort() && this.hasNestedObjects()) {
            throw new IllegalArgumentException("cannot have nested fields when index sort is activated");
        }
        if (checkLimits) {
            this.fieldMappers.checkLimits(settings);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.mapping.toXContent(builder, params);
    }

    public String toString() {
        return "DocumentMapper{type='" + this.type + '\'' + ", typeText=" + this.typeText + ", mappingSource=" + this.mappingSource + ", mapping=" + this.mapping + ", documentParser=" + this.documentParser + ", fieldMappers=" + this.fieldMappers + ", objectMappers=" + this.mappers().objectMappers() + ", hasNestedObjects=" + this.hasNestedObjects() + ", deleteTombstoneMetadataFieldMappers=" + Arrays.toString(this.deleteTombstoneMetadataFieldMappers) + ", noopTombstoneMetadataFieldMappers=" + Arrays.toString(this.noopTombstoneMetadataFieldMappers) + '}';
    }

    public static class Builder {
        private final Map<Class<? extends MetadataFieldMapper>, MetadataFieldMapper> metadataMappers;
        private final RootObjectMapper rootObjectMapper;
        private final ContentPath contentPath;
        private final IndexSettings indexSettings;
        private final IndexAnalyzers indexAnalyzers;
        private final DocumentParser documentParser;
        private Map<String, Object> meta;

        public Builder(RootObjectMapper.Builder builder, MapperService mapperService) {
            this(builder, mapperService.getIndexSettings(), mapperService.getIndexAnalyzers(), mapperService.documentParser(), mapperService::getMetadataMappers);
        }

        Builder(RootObjectMapper.Builder builder, IndexSettings indexSettings, IndexAnalyzers indexAnalyzers, DocumentParser documentParser, Function<String, Map<Class<? extends MetadataFieldMapper>, MetadataFieldMapper>> metadataMappersFunction) {
            this.indexSettings = indexSettings;
            this.indexAnalyzers = indexAnalyzers;
            this.documentParser = documentParser;
            this.contentPath = new ContentPath(1);
            this.rootObjectMapper = builder.build(this.contentPath);
            this.metadataMappers = metadataMappersFunction.apply(this.rootObjectMapper.name());
        }

        public Builder meta(Map<String, Object> meta) {
            this.meta = meta;
            return this;
        }

        public Builder put(MetadataFieldMapper.Builder mapper) {
            MetadataFieldMapper metadataMapper = mapper.build(this.contentPath);
            this.metadataMappers.put(metadataMapper.getClass(), metadataMapper);
            return this;
        }

        public DocumentMapper build() {
            Objects.requireNonNull(this.rootObjectMapper, "Mapper builder must have the root object mapper set");
            Mapping mapping = new Mapping(this.rootObjectMapper, this.metadataMappers.values().toArray(new MetadataFieldMapper[0]), this.meta);
            return new DocumentMapper(this.indexSettings, this.indexAnalyzers, this.documentParser, mapping);
        }
    }
}

