/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.SortedSetOrdinalsIndexFieldData;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TextParams;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.similarity.SimilarityProvider;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.lookup.SearchLookup;

public final class KeywordFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "keyword";
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, c.getIndexAnalyzers()));
    private final boolean indexed;
    private final boolean hasDocValues;
    private final String nullValue;
    private final boolean eagerGlobalOrdinals;
    private final int ignoreAbove;
    private final String indexOptions;
    private final FieldType fieldType;
    private final SimilarityProvider similarity;
    private final String normalizerName;
    private final boolean splitQueriesOnWhitespace;
    private final IndexAnalyzers indexAnalyzers;

    private static KeywordFieldMapper toType(FieldMapper in) {
        return (KeywordFieldMapper)in;
    }

    protected KeywordFieldMapper(String simpleName, FieldType fieldType, KeywordFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Builder builder) {
        super(simpleName, (MappedFieldType)mappedFieldType, mappedFieldType.normalizer, multiFields, copyTo);
        assert (fieldType.indexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS) <= 0);
        this.indexed = (Boolean)builder.indexed.getValue();
        this.hasDocValues = (Boolean)builder.hasDocValues.getValue();
        this.nullValue = (String)builder.nullValue.getValue();
        this.eagerGlobalOrdinals = (Boolean)builder.eagerGlobalOrdinals.getValue();
        this.ignoreAbove = (Integer)builder.ignoreAbove.getValue();
        this.indexOptions = (String)builder.indexOptions.getValue();
        this.fieldType = fieldType;
        this.similarity = (SimilarityProvider)builder.similarity.getValue();
        this.normalizerName = (String)builder.normalizer.getValue();
        this.splitQueriesOnWhitespace = (Boolean)builder.splitQueriesOnWhitespace.getValue();
        this.indexAnalyzers = builder.indexAnalyzers;
    }

    @Override
    public KeywordFieldType fieldType() {
        return (KeywordFieldType)super.fieldType();
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        XContentParser parser;
        String value = context.externalValueSet() ? context.externalValue().toString() : ((parser = context.parser()).currentToken() == XContentParser.Token.VALUE_NULL ? this.nullValue : parser.textOrNull());
        if (value == null || value.length() > this.ignoreAbove) {
            return;
        }
        NamedAnalyzer normalizer = this.fieldType().normalizer();
        if (normalizer != null) {
            value = KeywordFieldMapper.normalizeValue(normalizer, this.name(), value);
        }
        BytesRef binaryValue = new BytesRef((CharSequence)value);
        if (this.fieldType.indexOptions() != IndexOptions.NONE || this.fieldType.stored()) {
            KeywordField field = new KeywordField(this.fieldType().name(), binaryValue, this.fieldType);
            context.doc().add((IndexableField)field);
            if (!this.fieldType().hasDocValues() && this.fieldType.omitNorms()) {
                this.createFieldNamesField(context);
            }
        }
        if (this.fieldType().hasDocValues()) {
            context.doc().add((IndexableField)new SortedSetDocValuesField(this.fieldType().name(), binaryValue));
        }
    }

    private static String normalizeValue(NamedAnalyzer normalizer, String field, String value) throws IOException {
        try (TokenStream ts = normalizer.tokenStream(field, value);){
            CharTermAttribute termAtt = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
            ts.reset();
            if (!ts.incrementToken()) {
                throw new IllegalStateException("The normalization token stream is expected to produce exactly 1 token, but got 0 for analyzer " + (Object)((Object)normalizer) + " and input \"" + value + "\"");
            }
            String newValue = termAtt.toString();
            if (ts.incrementToken()) {
                throw new IllegalStateException("The normalization token stream is expected to produce exactly 1 token, but got 2+ for analyzer " + (Object)((Object)normalizer) + " and input \"" + value + "\"");
            }
            ts.end();
            String string = newValue;
            return string;
        }
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.indexAnalyzers).init(this);
    }

    public static final class KeywordFieldType
    extends StringFieldType {
        private final int ignoreAbove;
        private final String nullValue;
        private final NamedAnalyzer normalizer;

        public KeywordFieldType(String name, FieldType fieldType, NamedAnalyzer normalizer, NamedAnalyzer searchAnalyzer, NamedAnalyzer quoteAnalyzer, Builder builder) {
            super(name, fieldType.indexOptions() != IndexOptions.NONE, fieldType.stored(), (Boolean)builder.hasDocValues.getValue(), new TextSearchInfo(fieldType, (SimilarityProvider)builder.similarity.getValue(), searchAnalyzer, quoteAnalyzer), (Map)builder.meta.getValue());
            this.setEagerGlobalOrdinals((Boolean)builder.eagerGlobalOrdinals.getValue());
            this.setBoost(((Float)builder.boost.getValue()).floatValue());
            this.normalizer = normalizer;
            this.ignoreAbove = (Integer)builder.ignoreAbove.getValue();
            this.nullValue = (String)builder.nullValue.getValue();
        }

        public KeywordFieldType(String name, boolean isSearchable, boolean hasDocValues, Map<String, String> meta) {
            super(name, isSearchable, false, hasDocValues, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            this.normalizer = Lucene.KEYWORD_ANALYZER;
            this.ignoreAbove = Integer.MAX_VALUE;
            this.nullValue = null;
        }

        public KeywordFieldType(String name) {
            this(name, true, true, Collections.emptyMap());
        }

        public KeywordFieldType(String name, FieldType fieldType) {
            super(name, fieldType.indexOptions() != IndexOptions.NONE, false, false, new TextSearchInfo(fieldType, null, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER), Collections.emptyMap());
            this.normalizer = Lucene.KEYWORD_ANALYZER;
            this.ignoreAbove = Integer.MAX_VALUE;
            this.nullValue = null;
        }

        public KeywordFieldType(String name, NamedAnalyzer analyzer) {
            super(name, true, false, true, new TextSearchInfo(Defaults.FIELD_TYPE, null, analyzer, analyzer), Collections.emptyMap());
            this.normalizer = Lucene.KEYWORD_ANALYZER;
            this.ignoreAbove = Integer.MAX_VALUE;
            this.nullValue = null;
        }

        @Override
        public String typeName() {
            return KeywordFieldMapper.CONTENT_TYPE;
        }

        NamedAnalyzer normalizer() {
            return this.normalizer;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new SortedSetOrdinalsIndexFieldData.Builder(this.name(), CoreValuesSourceType.BYTES);
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new SourceValueFetcher(this.name(), context, this.nullValue){

                @Override
                protected String parseSourceValue(Object value) {
                    String keywordValue = value.toString();
                    if (keywordValue.length() > ignoreAbove) {
                        return null;
                    }
                    NamedAnalyzer normalizer = this.normalizer();
                    if (normalizer == null) {
                        return keywordValue;
                    }
                    try {
                        return KeywordFieldMapper.normalizeValue(normalizer, this.name(), keywordValue);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            };
        }

        @Override
        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            BytesRef binaryValue = (BytesRef)value;
            return binaryValue.utf8ToString();
        }

        @Override
        protected BytesRef indexedValueForSearch(Object value) {
            if (this.getTextSearchInfo().getSearchAnalyzer() == Lucene.KEYWORD_ANALYZER) {
                return super.indexedValueForSearch(value);
            }
            if (value == null) {
                return null;
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            return this.getTextSearchInfo().getSearchAnalyzer().normalize(this.name(), value.toString());
        }

        @Override
        public MappedFieldType.CollapseType collapseType() {
            return MappedFieldType.CollapseType.KEYWORD;
        }

        public int ignoreAbove() {
            return this.ignoreAbove;
        }
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<Boolean> indexed = FieldMapper.Parameter.indexParam(m -> KeywordFieldMapper.access$1000(KeywordFieldMapper.toType(m)), true);
        private final FieldMapper.Parameter<Boolean> hasDocValues = FieldMapper.Parameter.docValuesParam(m -> KeywordFieldMapper.access$900(KeywordFieldMapper.toType(m)), true);
        private final FieldMapper.Parameter<Boolean> stored = FieldMapper.Parameter.storeParam(m -> KeywordFieldMapper.toType(m).fieldType.stored(), false);
        private final FieldMapper.Parameter<String> nullValue = FieldMapper.Parameter.stringParam("null_value", false, m -> KeywordFieldMapper.access$800(KeywordFieldMapper.toType(m)), null).acceptsNull();
        private final FieldMapper.Parameter<Boolean> eagerGlobalOrdinals = FieldMapper.Parameter.boolParam("eager_global_ordinals", true, m -> KeywordFieldMapper.access$700(KeywordFieldMapper.toType(m)), false);
        private final FieldMapper.Parameter<Integer> ignoreAbove = FieldMapper.Parameter.intParam("ignore_above", true, m -> KeywordFieldMapper.access$600(KeywordFieldMapper.toType(m)), Integer.MAX_VALUE);
        private final FieldMapper.Parameter<String> indexOptions = FieldMapper.Parameter.restrictedStringParam("index_options", false, m -> KeywordFieldMapper.access$500(KeywordFieldMapper.toType(m)), "docs", "freqs");
        private final FieldMapper.Parameter<Boolean> hasNorms = TextParams.norms(false, m -> !KeywordFieldMapper.toType(m).fieldType.omitNorms());
        private final FieldMapper.Parameter<SimilarityProvider> similarity = TextParams.similarity(m -> KeywordFieldMapper.access$300(KeywordFieldMapper.toType(m)));
        private final FieldMapper.Parameter<String> normalizer = FieldMapper.Parameter.stringParam("normalizer", false, m -> KeywordFieldMapper.access$200(KeywordFieldMapper.toType(m)), null).acceptsNull();
        private final FieldMapper.Parameter<Boolean> splitQueriesOnWhitespace = FieldMapper.Parameter.boolParam("split_queries_on_whitespace", true, m -> KeywordFieldMapper.access$100(KeywordFieldMapper.toType(m)), false);
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final FieldMapper.Parameter<Float> boost = FieldMapper.Parameter.boostParam();
        private final IndexAnalyzers indexAnalyzers;

        public Builder(String name, IndexAnalyzers indexAnalyzers) {
            super(name);
            this.indexAnalyzers = indexAnalyzers;
        }

        public Builder(String name) {
            this(name, null);
        }

        public Builder ignoreAbove(int ignoreAbove) {
            this.ignoreAbove.setValue(ignoreAbove);
            return this;
        }

        Builder normalizer(String normalizerName) {
            this.normalizer.setValue(normalizerName);
            return this;
        }

        Builder nullValue(String nullValue) {
            this.nullValue.setValue(nullValue);
            return this;
        }

        public Builder docValues(boolean hasDocValues) {
            this.hasDocValues.setValue(hasDocValues);
            return this;
        }

        @Override
        protected List<FieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.indexed, this.hasDocValues, this.stored, this.nullValue, this.eagerGlobalOrdinals, this.ignoreAbove, this.indexOptions, this.hasNorms, this.similarity, this.normalizer, this.splitQueriesOnWhitespace, this.boost, this.meta);
        }

        private KeywordFieldType buildFieldType(ContentPath contentPath, FieldType fieldType) {
            NamedAnalyzer normalizer = Lucene.KEYWORD_ANALYZER;
            NamedAnalyzer searchAnalyzer = Lucene.KEYWORD_ANALYZER;
            NamedAnalyzer quoteAnalyzer = Lucene.KEYWORD_ANALYZER;
            String normalizerName = this.normalizer.getValue();
            if (normalizerName != null) {
                assert (this.indexAnalyzers != null);
                normalizer = this.indexAnalyzers.getNormalizer(normalizerName);
                if (normalizer == null) {
                    throw new MapperParsingException("normalizer [" + normalizerName + "] not found for field [" + this.name + "]");
                }
                searchAnalyzer = quoteAnalyzer = normalizer;
                if (this.splitQueriesOnWhitespace.getValue().booleanValue()) {
                    searchAnalyzer = this.indexAnalyzers.getWhitespaceNormalizer(normalizerName);
                }
            } else if (this.splitQueriesOnWhitespace.getValue().booleanValue()) {
                searchAnalyzer = Lucene.WHITESPACE_ANALYZER;
            }
            return new KeywordFieldType(this.buildFullName(contentPath), fieldType, normalizer, searchAnalyzer, quoteAnalyzer, this);
        }

        @Override
        public KeywordFieldMapper build(ContentPath contentPath) {
            FieldType fieldtype = new FieldType((IndexableFieldType)Defaults.FIELD_TYPE);
            fieldtype.setOmitNorms(this.hasNorms.getValue() == false);
            fieldtype.setIndexOptions(TextParams.toIndexOptions(this.indexed.getValue(), this.indexOptions.getValue()));
            fieldtype.setStored(this.stored.getValue().booleanValue());
            return new KeywordFieldMapper(this.name, fieldtype, this.buildFieldType(contentPath, fieldtype), this.multiFieldsBuilder.build(this, contentPath), this.copyTo.build(), this);
        }
    }

    public static class KeywordField
    extends Field {
        public KeywordField(String field, BytesRef term, FieldType ft) {
            super(field, term, (IndexableFieldType)ft);
        }
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.freeze();
        }
    }
}

